/*******************************************************************************
  * Copyright (c) 2008-2009 Red Hat, Inc.
  * Distributed under license by Red Hat, Inc. All rights reserved.
  * This program is made available under the terms of the
  * Eclipse Public License v1.0 which accompanies this distribution,
  * and is available at http://www.eclipse.org/legal/epl-v10.html
  *
  * Contributor:
  *     Red Hat, Inc. - initial API and implementation
  ******************************************************************************/
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.ListIterator;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.utility.TextRange;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GenericGeneratorAnnotation;

/**
 * @author Dmitry Geraskov
 *
 */
public interface JavaGenericGenerator extends JavaGenerator, GenericGenerator {
	
	@SuppressWarnings("unchecked")
	ListIterator<JavaParameter> parameters();
	
	JavaParameter addParameter(int index);
	
	// **************** validation *********************************************
	
	TextRange getNameTextRange(CompilationUnit astRoot);
	
	void initialize(GenericGeneratorAnnotation generator);
	
	void update(GenericGeneratorAnnotation generator);

}

