/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.plan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ExternalizeUtil;

@XmlType
@XmlRootElement(name="node")
public class PlanNode
implements Externalizable {
    @XmlElement(name="property")
    private List<Property> properties = new LinkedList<Property>();
    private PlanNode parent;
    @XmlAttribute
    private String name;

    public PlanNode() {
    }

    public PlanNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void setParent(PlanNode parent) {
        this.parent = parent;
    }

    public PlanNode getParent() {
        return this.parent;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(String pname, PlanNode value) {
        Property p = new Property(pname);
        p.setPlanNode(value);
        value.setParent(this);
        this.properties.add(p);
    }

    public void addProperty(String pname, List<String> value) {
        Property p = new Property(pname);
        if (value == null) {
            value = Collections.emptyList();
        }
        p.setValues(value);
        this.properties.add(p);
    }

    public void addProperty(String pname, String value) {
        Property p = new Property(pname);
        p.setValues(Arrays.asList(value));
        this.properties.add(p);
    }

    public String toXml() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{PlanNode.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)this, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new TeiidRuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.visitNode(this, 0, builder);
        return builder.toString();
    }

    protected void visitNode(PlanNode node, int nodeLevel, StringBuilder text) {
        for (int i = 0; i < nodeLevel; ++i) {
            text.append("  ");
        }
        text.append(node.getName());
        text.append("\n");
        int propTabs = nodeLevel + 1;
        for (Property property : node.getProperties()) {
            for (int t = 0; t < propTabs; ++t) {
                text.append("  ");
            }
            this.printProperty(nodeLevel, property, text);
        }
    }

    private void printProperty(int nodeLevel, Property p, StringBuilder text) {
        text.append("+ ");
        text.append(p.getName());
        if (p.getPlanNode() != null) {
            text.append(":\n");
            this.visitNode(p.getPlanNode(), nodeLevel + 2, text);
        } else if (p.getValues().size() > 1) {
            text.append(":\n");
            for (int i = 0; i < p.getValues().size(); ++i) {
                for (int t = 0; t < nodeLevel + 2; ++t) {
                    text.append("  ");
                }
                text.append(i);
                text.append(": ");
                text.append(p.getValues().get(i));
                text.append("\n");
            }
        } else if (p.getValues().size() == 1) {
            text.append(":");
            text.append(p.getValues().get(0));
            text.append("\n");
        } else {
            text.append("\n");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.properties = ExternalizeUtil.readList(in, Property.class);
        this.parent = (PlanNode)in.readObject();
        this.name = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizeUtil.writeCollection(out, this.properties);
        out.writeObject(this.parent);
        out.writeObject(this.name);
    }

    @XmlType(name="property")
    public static class Property
    implements Externalizable {
        @XmlAttribute
        private String name;
        private List<String> values;
        private PlanNode planNode;

        public Property() {
        }

        public Property(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @XmlElement(name="value")
        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        @XmlElement(name="node")
        public PlanNode getPlanNode() {
            return this.planNode;
        }

        public void setPlanNode(PlanNode planNode) {
            this.planNode = planNode;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            this.values = ExternalizeUtil.readList(in, String.class);
            this.planNode = (PlanNode)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.name);
            ExternalizeUtil.writeCollection(out, this.values);
            out.writeObject(this.planNode);
        }
    }
}

