/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.Assertion;

public class BatchResults {
    static final int DEFAULT_SAVED_BATCHES = 3;
    private ArrayList<Batch> batches = new ArrayList();
    private int currentRowNumber;
    private List<?> currentRow;
    private int lastRowNumber = -1;
    private int highestRowNumber;
    private BatchFetcher batchFetcher;
    private int savedBatches = 3;

    public BatchResults(List[] batch, int beginRow, int endRow, boolean isLast) {
        this.setBatch(new Batch(batch, beginRow, endRow, isLast));
    }

    public BatchResults(BatchFetcher batchFetcher, Batch batch, int savedBatches) {
        this.batchFetcher = batchFetcher;
        this.savedBatches = savedBatches;
        this.setBatch(batch);
    }

    public List getCurrentRow() throws SQLException {
        if (this.currentRow != null) {
            return this.currentRow;
        }
        if (this.currentRowNumber == 0 || this.lastRowNumber != -1 && this.currentRowNumber > this.lastRowNumber) {
            return null;
        }
        for (int i = 0; i < this.batches.size(); ++i) {
            Batch batch = this.batches.get(i);
            if (this.currentRowNumber < batch.getBeginRow() || this.currentRowNumber > batch.getEndRow()) continue;
            if (i != 0) {
                this.batches.add(0, this.batches.remove(i));
            }
            this.currentRow = batch.getRow(this.currentRowNumber);
            return this.currentRow;
        }
        this.requestBatchAndWait(this.currentRowNumber);
        Batch batch = this.batches.get(0);
        this.currentRow = batch.getRow(this.currentRowNumber);
        return this.currentRow;
    }

    private void requestNextBatch() throws SQLException {
        this.requestBatchAndWait(this.highestRowNumber + 1);
    }

    public boolean next() throws SQLException {
        if (this.hasNext()) {
            this.setCurrentRowNumber(this.currentRowNumber + 1);
            this.getCurrentRow();
            return true;
        }
        if (this.currentRowNumber == this.highestRowNumber) {
            this.setCurrentRowNumber(this.currentRowNumber + 1);
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.currentRowNumber != 0 && this.currentRowNumber != 1;
    }

    public boolean previous() {
        if (this.hasPrevious()) {
            this.setCurrentRowNumber(this.currentRowNumber - 1);
            return true;
        }
        if (this.currentRowNumber == 1) {
            this.setCurrentRowNumber(this.currentRowNumber - 1);
        }
        return false;
    }

    public void setBatchFetcher(BatchFetcher batchFetcher) {
        this.batchFetcher = batchFetcher;
    }

    public boolean absolute(int row) throws SQLException {
        return this.absolute(row, 0);
    }

    public boolean absolute(int row, int offset) throws SQLException {
        if (row == 0) {
            this.setCurrentRowNumber(0);
            return false;
        }
        if (row > 0) {
            while (row + offset > this.highestRowNumber && this.lastRowNumber == -1) {
                this.requestNextBatch();
            }
            if (row + offset <= this.highestRowNumber) {
                this.setCurrentRowNumber(row);
                return true;
            }
            this.setCurrentRowNumber(this.lastRowNumber + 1 - offset);
            return false;
        }
        row -= offset;
        while (this.lastRowNumber == -1) {
            this.requestNextBatch();
        }
        int positiveRow = this.lastRowNumber + row + 1;
        if (positiveRow <= 0) {
            this.setCurrentRowNumber(0);
            return false;
        }
        this.setCurrentRowNumber(positiveRow);
        return true;
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void requestBatchAndWait(int beginRow) throws SQLException {
        if (this.batches.size() == this.savedBatches) {
            this.batches.remove(this.savedBatches - 1);
        }
        this.setBatch(this.batchFetcher.requestBatch(beginRow));
    }

    private void setBatch(Batch batch) {
        Assertion.assertTrue(batch.getLength() != 0 || batch.isLast());
        if (batch.isLast()) {
            this.lastRowNumber = batch.getEndRow();
        }
        this.highestRowNumber = Math.max(batch.getEndRow(), this.highestRowNumber);
        this.batches.add(0, batch);
    }

    public boolean hasNext() throws SQLException {
        return this.hasNext(1);
    }

    public boolean hasNext(int next) throws SQLException {
        while (this.currentRowNumber + next > this.highestRowNumber && this.lastRowNumber == -1) {
            this.requestNextBatch();
        }
        return this.currentRowNumber + next <= this.highestRowNumber;
    }

    public int getFinalRowNumber() {
        return this.lastRowNumber;
    }

    public int getHighestRowNumber() {
        return this.highestRowNumber;
    }

    private void setCurrentRowNumber(int currentRowNumber) {
        if (currentRowNumber != this.currentRowNumber) {
            this.currentRow = null;
        }
        this.currentRowNumber = currentRowNumber;
    }

    static class Batch {
        private List[] batch;
        private int beginRow;
        private int endRow;
        private boolean isLast;

        Batch(List[] batch, int beginRow, int endRow, boolean isLast) {
            this.batch = batch;
            this.beginRow = beginRow;
            this.endRow = endRow;
            this.isLast = isLast;
        }

        int getLength() {
            return this.batch.length;
        }

        List getRow(int index) {
            return this.batch[index - this.beginRow];
        }

        int getBeginRow() {
            return this.beginRow;
        }

        int getEndRow() {
            return this.endRow;
        }

        boolean isLast() {
            return this.isLast;
        }
    }

    public static interface BatchFetcher {
        public Batch requestBatch(int var1) throws SQLException;
    }
}

