/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.teiid.logging.LogManager;

public abstract class AbstractWorkItem
implements Work,
WorkListener {
    private ThreadState threadState = ThreadState.MORE_WORK;
    private volatile boolean isProcessing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.startProcessing();
        try {
            this.process();
        }
        finally {
            this.endProcessing();
        }
    }

    synchronized ThreadState getThreadState() {
        return this.threadState;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    private synchronized void startProcessing() {
        this.isProcessing = true;
        this.logTrace("start processing");
        if (this.threadState != ThreadState.MORE_WORK) {
            throw new IllegalStateException("Must be in MORE_WORK");
        }
        this.threadState = ThreadState.WORKING;
    }

    private synchronized void endProcessing() {
        this.isProcessing = false;
        this.logTrace("end processing");
        switch (this.threadState) {
            case WORKING: {
                if (this.isDoneProcessing()) {
                    this.logTrace("done processing");
                    this.threadState = ThreadState.DONE;
                    break;
                }
                this.threadState = ThreadState.IDLE;
                this.pauseProcessing();
                break;
            }
            case MORE_WORK: {
                if (this.isDoneProcessing()) {
                    this.logTrace("done processing - ignoring more");
                    this.threadState = ThreadState.DONE;
                    break;
                }
                this.resumeProcessing();
                break;
            }
            default: {
                throw new IllegalStateException("Should not END on " + (Object)((Object)this.threadState));
            }
        }
    }

    protected boolean isIdle() {
        return this.threadState == ThreadState.IDLE;
    }

    public void moreWork() {
        this.moreWork(true);
    }

    protected synchronized void moreWork(boolean ignoreDone) {
        this.logTrace("more work");
        switch (this.threadState) {
            case WORKING: {
                this.threadState = ThreadState.MORE_WORK;
                break;
            }
            case MORE_WORK: {
                break;
            }
            case IDLE: {
                this.threadState = ThreadState.MORE_WORK;
                this.resumeProcessing();
                break;
            }
            default: {
                if (!ignoreDone) {
                    throw new IllegalStateException("More work is not valid once DONE");
                }
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this, "ignoring more work, since the work item is done"});
            }
        }
    }

    private void logTrace(String msg) {
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this, msg, this.threadState});
    }

    protected abstract void process();

    protected void pauseProcessing() {
    }

    protected abstract void resumeProcessing();

    protected abstract boolean isDoneProcessing();

    public abstract String toString();

    public void release() {
    }

    public void workAccepted(WorkEvent arg0) {
    }

    public void workCompleted(WorkEvent arg0) {
    }

    public void workRejected(WorkEvent event) {
    }

    public void workStarted(WorkEvent arg0) {
    }

    static enum ThreadState {
        MORE_WORK,
        WORKING,
        IDLE,
        DONE;

    }
}

