/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.query.QueryPlugin;
import org.teiid.query.util.CommandContext;

public class FunctionDescriptor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5374103983118037242L;
    private static final boolean ALLOW_NAN_INFINITY = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.allowNanInfinity", (boolean)false);
    private String name;
    private int pushdown;
    private Class[] types;
    private Class returnType;
    private int hash;
    private boolean requiresContext;
    private boolean nullDependent;
    private int deterministic;
    private transient Method invocationMethod;

    FunctionDescriptor() {
    }

    FunctionDescriptor(String name, int pushdown, Class[] types, Class returnType, Method invocationMethod, boolean requiresContext, boolean nullDependent, int deterministic) {
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)types);
        Assertion.isNotNull((Object)returnType);
        this.name = name;
        this.pushdown = pushdown;
        this.types = types;
        this.returnType = returnType;
        this.invocationMethod = invocationMethod;
        this.requiresContext = requiresContext;
        this.nullDependent = nullDependent;
        this.deterministic = deterministic;
        this.hash = HashCodeUtil.hashCode((int)0, (Object[])new Object[]{name});
        for (int i = 0; i < types.length; ++i) {
            this.hash = HashCodeUtil.hashCode((int)this.hash, (Object[])new Object[]{types[i]});
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPushdown() {
        return this.pushdown;
    }

    void setPushdown(int pushdown) {
        this.pushdown = pushdown;
    }

    public Class[] getTypes() {
        return this.types;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    Method getInvocationMethod() {
        return this.invocationMethod;
    }

    public boolean requiresContext() {
        return this.requiresContext;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        Class[] otherTypes;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor other = (FunctionDescriptor)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        Class[] thisTypes = this.getTypes();
        if (thisTypes.length != (otherTypes = other.getTypes()).length) {
            return false;
        }
        for (int i = 0; i < thisTypes.length; ++i) {
            if (thisTypes[i].equals(otherTypes[i])) continue;
            return false;
        }
        if (this.nullDependent != other.isNullDependent()) {
            return false;
        }
        return this.deterministic == other.deterministic;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.name);
        str.append("(");
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != null) {
                str.append(this.types[i].getName());
            } else {
                str.append("null");
            }
            if (i >= this.types.length - 1) continue;
            str.append(", ");
        }
        str.append(") : ");
        if (this.returnType == null) {
            str.append("null");
        } else {
            str.append(this.returnType.getName());
        }
        return str.toString();
    }

    public boolean isNullDependent() {
        return this.nullDependent;
    }

    public int getDeterministic() {
        return this.deterministic;
    }

    void setDeterministic(int deterministic) {
        this.deterministic = deterministic;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public Object invokeFunction(Object[] values) throws FunctionExecutionException {
        Method method;
        if (!this.isNullDependent()) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                return null;
            }
        }
        if ((method = this.getInvocationMethod()) == null) {
            throw new FunctionExecutionException("ERR.015.001.0002", QueryPlugin.Util.getString("ERR.015.001.0002", new Object[]{this.getName()}));
        }
        if (this.getDeterministic() >= 2 && values.length > 0 && values[0] instanceof CommandContext) {
            CommandContext cc = (CommandContext)values[0];
            cc.setDeterminismLevel(this.getDeterministic());
        }
        try {
            if (method.isVarArgs()) {
                int i = method.getParameterTypes().length;
                Object[] newValues = Arrays.copyOf(values, i);
                newValues[i - 1] = Arrays.copyOfRange(values, i - 1, values.length);
                values = newValues;
            }
            Object result = method.invoke(null, values);
            return FunctionDescriptor.importValue(result, this.getReturnType());
        }
        catch (ArithmeticException e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0003", QueryPlugin.Util.getString("ERR.015.001.0003", new Object[]{this.getName()}));
        }
        catch (InvocationTargetException e) {
            throw new FunctionExecutionException(e.getTargetException(), "ERR.015.001.0003", QueryPlugin.Util.getString("ERR.015.001.0003", new Object[]{this.getName()}));
        }
        catch (IllegalAccessException e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0004", QueryPlugin.Util.getString("ERR.015.001.0004", new Object[]{method.toString()}));
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException(e, e.getMessage());
        }
    }

    public static Object importValue(Object result, Class<?> expectedType) throws ArithmeticException, TransformationException {
        String s;
        Number floatVal;
        if (!ALLOW_NAN_INFINITY && (result instanceof Double ? Double.isInfinite((Double)(floatVal = (Double)result)) || Double.isNaN((Double)floatVal) : result instanceof Float && (Float.isInfinite(((Float)(floatVal = (Float)result)).floatValue()) || Float.isNaN(((Float)floatVal).floatValue())))) {
            throw new ArithmeticException("Infinite or invalid result");
        }
        result = DataTypeManager.convertToRuntimeType((Object)result);
        if ((result = DataTypeManager.transformValue((Object)result, expectedType)) instanceof String && (s = (String)result).length() > 4000) {
            return s.substring(0, 4000);
        }
        return result;
    }
}

