/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionForm;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionParameter;
import org.teiid.query.util.CommandContext;

public class FunctionTree {
    private static final Integer DESCRIPTOR_KEY = new Integer(-1);
    private Map<String, Set<String>> categories = new HashMap<String, Set<String>>();
    private Map<String, List<FunctionMethod>> functionsByName = new HashMap<String, List<FunctionMethod>>();
    private Set<FunctionMethod> allFunctions = new HashSet<FunctionMethod>();
    private Map treeRoot = new HashMap();
    private boolean validateClass;

    public FunctionTree(FunctionMetadataSource source) {
        this(source, false);
    }

    public FunctionTree(FunctionMetadataSource source, boolean validateClass) {
        this.validateClass = validateClass;
        this.addSource(source);
    }

    private void addSource(FunctionMetadataSource source) {
        if (source == null) {
            return;
        }
        Collection<FunctionMethod> functions = source.getFunctionMethods();
        if (functions != null) {
            for (FunctionMethod functionObj : functions) {
                FunctionMethod method;
                if (!(functionObj instanceof FunctionMethod)) {
                    Assertion.failed((String)QueryPlugin.Util.getString("ERR.015.001.0045", new Object[]{functionObj.getClass().getName()}));
                }
                if (!this.containsIndistinguishableFunction(method = functionObj)) {
                    this.addMetadata(method);
                    this.addFunction(source, method);
                    continue;
                }
                LogManager.logWarning((String)"org.teiid.PLANNER.FUNCTION_TREE", (String)QueryPlugin.Util.getString("ERR.015.001.0046", new Object[]{method}));
            }
        }
    }

    private boolean containsIndistinguishableFunction(FunctionMethod method) {
        return this.allFunctions.contains(method);
    }

    private void addMetadata(FunctionMethod method) {
        String categoryKey = method.getCategory();
        if (categoryKey == null) {
            method.setCategory("Miscellaneous");
            categoryKey = "Miscellaneous";
        }
        categoryKey = categoryKey.toUpperCase();
        String nameKey = method.getName().toUpperCase();
        Set<String> functions = this.categories.get(categoryKey);
        if (functions == null) {
            functions = new HashSet<String>();
            this.categories.put(categoryKey, functions);
        }
        functions.add(nameKey);
        List<FunctionMethod> knownMethods = this.functionsByName.get(nameKey);
        if (knownMethods == null) {
            knownMethods = new ArrayList<FunctionMethod>();
            this.functionsByName.put(nameKey, knownMethods);
        }
        knownMethods.add(method);
        this.allFunctions.add(method);
    }

    Collection<String> getCategories() {
        return this.categories.keySet();
    }

    Collection<FunctionForm> getFunctionForms(String category) {
        HashSet<FunctionForm> functionForms = new HashSet<FunctionForm>();
        Set<String> functions = this.categories.get(category.toUpperCase());
        if (functions != null) {
            for (String functionName : functions) {
                for (FunctionMethod functionMethod : this.functionsByName.get(functionName)) {
                    functionForms.add(new FunctionForm(functionMethod));
                }
            }
        }
        return functionForms;
    }

    FunctionForm findFunctionForm(String name, int args) {
        List<FunctionMethod> results = this.findFunctionMethods(name, args);
        if (results.size() > 0) {
            return new FunctionForm(results.get(0));
        }
        return null;
    }

    List<FunctionMethod> findFunctionMethods(String name, int args) {
        ArrayList<FunctionMethod> allMatches = new ArrayList<FunctionMethod>();
        List<FunctionMethod> methods = this.functionsByName.get(name.toUpperCase());
        if (methods == null || methods.size() == 0) {
            return allMatches;
        }
        for (FunctionMethod functionMethod : methods) {
            if (functionMethod.getInputParameterCount() != args && (!functionMethod.isVarArgs() || args < functionMethod.getInputParameterCount() - 1)) continue;
            allMatches.add(functionMethod);
        }
        return allMatches;
    }

    private void addFunction(FunctionMetadataSource source, FunctionMethod method) {
        String methodName = method.getName();
        FunctionParameter[] inputParams = method.getInputParameters();
        LinkedList inputTypes = new LinkedList();
        if (inputParams != null) {
            for (int i = 0; i < inputParams.length; ++i) {
                String typeName = inputParams[i].getType();
                inputTypes.add(DataTypeManager.getDataTypeClass((String)typeName));
            }
        }
        Class[] types = inputTypes.toArray(new Class[inputTypes.size()]);
        if (method.isVarArgs()) {
            inputTypes.set(inputTypes.size() - 1, Array.newInstance((Class)inputTypes.get(inputTypes.size() - 1), 0).getClass());
        }
        FunctionParameter outputParam = method.getOutputParameter();
        Class outputType = null;
        if (outputParam != null) {
            outputType = DataTypeManager.getDataTypeClass((String)outputParam.getType());
        }
        Method invocationMethod = null;
        boolean requiresContext = false;
        if (method.getPushdown() == 0 || method.getPushdown() == 1) {
            try {
                Class methodClass = source.getInvocationClass(method.getInvocationClass());
                ReflectionHelper helper = new ReflectionHelper(methodClass);
                try {
                    invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                }
                catch (NoSuchMethodException e) {
                    inputTypes.add(0, CommandContext.class);
                    invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                    requiresContext = true;
                }
            }
            catch (ClassNotFoundException e) {
                if (this.validateClass) {
                    throw new TeiidRuntimeException((Throwable)e, "ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.no_class", new Object[]{method.getName(), method.getInvocationClass()}));
                }
            }
            catch (NoSuchMethodException e) {
                throw new TeiidRuntimeException((Throwable)e, "ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.no_method", new Object[]{method, method.getInvocationClass(), method.getInvocationMethod()}));
            }
            catch (Exception e) {
                throw new TeiidRuntimeException((Throwable)e, "ERR.015.001.0047", QueryPlugin.Util.getString("ERR.015.001.0047", new Object[]{method, method.getInvocationClass(), method.getInvocationMethod()}));
            }
            if (invocationMethod != null) {
                Class<?> methodReturn = invocationMethod.getReturnType();
                if (methodReturn.equals(Void.TYPE)) {
                    throw new TeiidRuntimeException("ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.not_void", new Object[]{method.getName(), invocationMethod}));
                }
                int modifiers = invocationMethod.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    throw new TeiidRuntimeException("ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.not_public", new Object[]{method.getName(), invocationMethod}));
                }
                if (!Modifier.isStatic(modifiers)) {
                    throw new TeiidRuntimeException("ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.not_static", new Object[]{method.getName(), invocationMethod}));
                }
            }
        } else {
            inputTypes.add(0, CommandContext.class);
        }
        FunctionDescriptor descriptor = new FunctionDescriptor(method.getName(), method.getPushdown(), types, outputType, invocationMethod, requiresContext, method.isNullDependent(), method.getDeterministic());
        HashMap<Object, Cloneable> node = this.treeRoot;
        Object[] path = this.buildPath(methodName, types);
        for (int pathIndex = 0; pathIndex < path.length; ++pathIndex) {
            Object pathPart = path[pathIndex];
            HashMap<Object, Cloneable> children = (HashMap<Object, Cloneable>)node.get(pathPart);
            if (children == null) {
                children = new HashMap<Object, Cloneable>();
                node.put(pathPart, children);
            }
            if (method.isVarArgs() && pathIndex == path.length - 1) {
                node.put(DESCRIPTOR_KEY, descriptor);
            }
            node = children;
        }
        if (method.isVarArgs()) {
            node.put(types[types.length - 1], node);
        }
        node.put(DESCRIPTOR_KEY, descriptor);
    }

    FunctionDescriptor getFunction(String name, Class[] argTypes) {
        Object[] path = this.buildPath(name, argTypes);
        Map node = this.treeRoot;
        for (int i = 0; i < path.length; ++i) {
            if ((node = (Map)node.get(path[i])) != null) continue;
            return null;
        }
        if (node.containsKey(DESCRIPTOR_KEY)) {
            return (FunctionDescriptor)node.get(DESCRIPTOR_KEY);
        }
        return null;
    }

    private Object[] buildPath(String name, Class[] argTypes) {
        Object[] path = new Object[argTypes.length + 1];
        path[0] = name.toUpperCase();
        System.arraycopy(argTypes, 0, path, 1, argTypes.length);
        return path;
    }
}

