/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class ExecResolver
extends ProcedureContainerResolver {
    private void findCommandMetadata(Command command, TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        StoredProcedureInfo storedProcedureInfo;
        StoredProcedure storedProcedureCommand;
        block16: {
            storedProcedureCommand = (StoredProcedure)command;
            storedProcedureInfo = null;
            try {
                storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(storedProcedureCommand.getProcedureName());
            }
            catch (QueryMetadataException e) {
                String[] parts = storedProcedureCommand.getProcedureName().split("\\.", 2);
                if (parts.length > 1 && parts[0].equalsIgnoreCase(metadata.getVirtualDatabaseName())) {
                    try {
                        storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(parts[1]);
                        storedProcedureCommand.setProcedureName(parts[1]);
                    }
                    catch (QueryMetadataException e1) {
                        // empty catch block
                    }
                }
                if (storedProcedureInfo != null) break block16;
                throw e;
            }
        }
        storedProcedureCommand.setUpdateCount(storedProcedureInfo.getUpdateCount());
        storedProcedureCommand.setModelID(storedProcedureInfo.getModelID());
        storedProcedureCommand.setProcedureID(storedProcedureInfo.getProcedureID());
        storedProcedureCommand.setProcedureCallableName(storedProcedureInfo.getProcedureCallableName());
        List<SPParameter> oldParams = storedProcedureCommand.getParameters();
        boolean namedParameters = storedProcedureCommand.displayNamedParameters();
        if (oldParams.size() == 0) {
            storedProcedureCommand.setDisplayNamedParameters(true);
            namedParameters = true;
        }
        HashMap<Object, Expression> inputExpressions = new HashMap<Object, Expression>();
        for (SPParameter param : oldParams) {
            if (param.getExpression() == null) continue;
            if (namedParameters) {
                if (inputExpressions.put(param.getName().toUpperCase(), param.getExpression()) == null) continue;
                throw new QueryResolverException(QueryPlugin.Util.getString("ExecResolver.duplicate_named_params", new Object[]{param.getName().toUpperCase()}));
            }
            inputExpressions.put(new Integer(param.getIndex()), param.getExpression());
        }
        storedProcedureCommand.clearParameters();
        List<SPParameter> metadataParams = storedProcedureInfo.getParameters();
        ArrayList<SPParameter> clonedMetadataParams = new ArrayList<SPParameter>();
        int inputParams = 0;
        for (SPParameter metadataParameter : metadataParams) {
            if (metadataParameter.getParameterType() == 1 || metadataParameter.getParameterType() == 3) {
                ++inputParams;
            }
            SPParameter clonedParam = (SPParameter)metadataParameter.clone();
            clonedMetadataParams.add(clonedParam);
            storedProcedureCommand.setParameter(clonedParam);
        }
        if (!namedParameters && inputParams != inputExpressions.size()) {
            throw new QueryResolverException("ERR.015.008.0007", QueryPlugin.Util.getString("ERR.015.008.0007", new Object[]{new Integer(inputParams), new Integer(inputExpressions.size()), storedProcedureCommand.getGroup().toString()}));
        }
        Iterator<SPParameter> paramIter = clonedMetadataParams.iterator();
        int exprIndex = 1;
        HashSet<String> expected = new HashSet<String>();
        while (paramIter.hasNext()) {
            SPParameter param = paramIter.next();
            if (param.getParameterType() != 1 && param.getParameterType() != 3) continue;
            if (namedParameters) {
                String nameKey = param.getName();
                nameKey = metadata.getShortElementName(nameKey);
                Expression expr = (Expression)inputExpressions.remove(nameKey = nameKey.toUpperCase());
                if (expr == null) {
                    expr = ResolverUtil.getDefault(param.getParameterSymbol(), metadata);
                    param.setUsingDefault(true);
                    expected.add(nameKey);
                }
                param.setExpression(expr);
            } else {
                Expression expr = (Expression)inputExpressions.remove(new Integer(exprIndex));
                param.setExpression(expr);
            }
            ++exprIndex;
        }
        if (namedParameters && !inputExpressions.isEmpty()) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ExecResolver.invalid_named_params", new Object[]{inputExpressions.keySet(), expected}));
        }
        String procName = storedProcedureCommand.getProcedureName();
        List tempElements = storedProcedureCommand.getProjectedSymbols();
        boolean isVirtual = storedProcedureInfo.getQueryPlan() != null;
        discoveredMetadata.addTempGroup(procName, tempElements, isVirtual);
        GroupSymbol procGroup = new GroupSymbol(procName);
        procGroup.setProcedure(true);
        TempMetadataID tid = discoveredMetadata.getTempGroupID(procName);
        tid.setOriginalMetadataID(storedProcedureCommand.getProcedureID());
        procGroup.setMetadataID(tid);
        storedProcedureCommand.setGroup(procGroup);
    }

    @Override
    public GroupContext findChildCommandMetadata(ProcedureContainer container, TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        StoredProcedure storedProcedureCommand = (StoredProcedure)container;
        String procName = metadata.getFullName(storedProcedureCommand.getProcedureID());
        GroupContext context = new GroupContext();
        ArrayList<ElementSymbol> tempElements = new ArrayList<ElementSymbol>();
        for (SPParameter param : storedProcedureCommand.getParameters()) {
            if (param.getParameterType() != 1 && param.getParameterType() != 3) continue;
            ElementSymbol symbol = param.getParameterSymbol();
            tempElements.add(symbol);
        }
        ProcedureContainerResolver.addScalarGroup(procName, discoveredMetadata, context, tempElements);
        return context;
    }

    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        this.findCommandMetadata(command, metadata.getMetadataStore(), metadata);
        StoredProcedure storedProcedureCommand = (StoredProcedure)command;
        List<SPParameter> params = storedProcedureCommand.getParameters();
        if (params.size() > 0) {
            GroupContext externalGroups = storedProcedureCommand.getExternalGroupContexts();
            for (SPParameter param : params) {
                Expression expr = param.getExpression();
                if (expr == null) continue;
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                    QueryResolver.setChildMetadata(container.getCommand(), command);
                    QueryResolver.resolveCommand(container.getCommand(), Collections.EMPTY_MAP, metadata.getMetadata(), analysis);
                }
                ResolverVisitor.resolveLanguageObject(expr, null, externalGroups, metadata);
                Class paramType = param.getClassType();
                ResolverUtil.setDesiredType(expr, paramType, storedProcedureCommand);
                Class exprType = expr.getType();
                if (paramType == null || exprType == null) {
                    throw new QueryResolverException("ERR.015.008.0061", QueryPlugin.Util.getString("ERR.015.008.0061", new Object[]{storedProcedureCommand.getProcedureName(), param.getName()}));
                }
                String tgtType = DataTypeManager.getDataTypeName((Class)paramType);
                String srcType = DataTypeManager.getDataTypeName((Class)exprType);
                Expression result = null;
                try {
                    result = ResolverUtil.convertExpression(expr, tgtType, metadata);
                }
                catch (QueryResolverException e) {
                    throw new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("ExecResolver.Param_convert_fail", new Object[]{srcType, tgtType}));
                }
                param.setExpression(result);
            }
        }
    }

    @Override
    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
    }

    @Override
    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws TeiidComponentException, QueryMetadataException {
        StoredProcedureInfo storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(group.getCanonicalName());
        QueryNode plan = storedProcedureInfo.getQueryPlan();
        return plan.getQuery();
    }
}

