/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class TranslateCriteria
extends PredicateCriteria {
    private CriteriaSelector criteriaSelector;
    private List translations;

    public TranslateCriteria() {
    }

    public TranslateCriteria(CriteriaSelector selector) {
        this.criteriaSelector = selector;
    }

    public TranslateCriteria(CriteriaSelector selector, List translations) {
        this.criteriaSelector = selector;
        this.translations = translations;
    }

    public CriteriaSelector getSelector() {
        return this.criteriaSelector;
    }

    public void setSelector(CriteriaSelector selector) {
        this.criteriaSelector = selector;
    }

    public boolean hasTranslations() {
        if (this.translations != null) {
            return this.translations.size() > 0;
        }
        return false;
    }

    public void setTranslations(List translations) {
        this.translations = translations;
    }

    public void addTranslation(CompareCriteria criteria) {
        if (this.translations == null) {
            this.translations = new ArrayList();
        }
        this.translations.add(criteria);
    }

    public List getTranslations() {
        return this.translations;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        TranslateCriteria copy = new TranslateCriteria();
        copy.setSelector((CriteriaSelector)this.criteriaSelector.clone());
        if (this.hasTranslations()) {
            ArrayList<Criteria> newTrans = new ArrayList<Criteria>(this.getTranslations().size());
            for (Criteria crit : this.getTranslations()) {
                newTrans.add(crit);
            }
            copy.setTranslations(newTrans);
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TranslateCriteria)) {
            return false;
        }
        TranslateCriteria other = (TranslateCriteria)obj;
        return EquivalenceUtil.areEqual((Object)this.getSelector(), (Object)other.getSelector()) && EquivalenceUtil.areEqual((Object)this.getTranslations(), (Object)other.getTranslations());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getSelector()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getTranslations()});
        return myHash;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

