/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import net.jcip.annotations.Immutable;

@Immutable
public class RepositorySourceCapabilities {
    public static final boolean DEFAULT_SUPPORT_SAME_NAME_SIBLINGS = true;
    public static final boolean DEFAULT_SUPPORT_UPDATES = false;
    public static final boolean DEFAULT_SUPPORT_EVENTS = false;
    public static final boolean DEFAULT_SUPPORT_CREATING_WORKSPACES = false;
    public static final boolean DEFAULT_SUPPORT_REFERENCES = true;
    public static final boolean DEFAULT_SUPPORT_QUERIES = false;
    public static final boolean DEFAULT_SUPPORT_SEARCHES = false;
    public static final boolean DEFAULT_SUPPORT_LOCKS = false;
    public static final boolean DEFAULT_SUPPORT_AUTOMATIC_GARBAGE_COLLECTION = true;
    private final boolean sameNameSiblings;
    private final boolean updates;
    private final boolean events;
    private final boolean creatingWorkspaces;
    private final boolean references;
    private final boolean locks;
    private final boolean queries;
    private final boolean searches;
    private final boolean autoGarbageCollection;

    public RepositorySourceCapabilities() {
        this(true, false, false, false, true, false, false, false, true);
    }

    public RepositorySourceCapabilities(RepositorySourceCapabilities capabilities) {
        this(capabilities.supportsSameNameSiblings(), capabilities.supportsUpdates(), capabilities.supportsEvents(), capabilities.supportsCreatingWorkspaces(), capabilities.supportsReferences(), capabilities.supportsLocks(), capabilities.supportsQueries(), capabilities.supportsSearches(), capabilities.supportsAutomaticGarbageCollection());
    }

    public RepositorySourceCapabilities(boolean supportsSameNameSiblings, boolean supportsUpdates) {
        this(supportsSameNameSiblings, supportsUpdates, false, false, true, false, false, false, true);
    }

    public RepositorySourceCapabilities(boolean supportsSameNameSiblings, boolean supportsUpdates, boolean supportsEvents, boolean supportsCreatingWorkspaces, boolean supportsReferences) {
        this(supportsSameNameSiblings, supportsUpdates, supportsEvents, supportsCreatingWorkspaces, supportsReferences, false, false, false, true);
    }

    public RepositorySourceCapabilities(boolean supportsSameNameSiblings, boolean supportsUpdates, boolean supportsEvents, boolean supportsCreatingWorkspaces, boolean supportsReferences, boolean supportsLocks, boolean supportsQueries, boolean supportsSearches, boolean supportsAutomaticGarbageCollection) {
        this.sameNameSiblings = supportsSameNameSiblings;
        this.updates = supportsUpdates;
        this.events = supportsEvents;
        this.creatingWorkspaces = supportsCreatingWorkspaces;
        this.references = supportsReferences;
        this.locks = supportsLocks;
        this.queries = supportsQueries;
        this.searches = supportsSearches;
        this.autoGarbageCollection = supportsAutomaticGarbageCollection;
    }

    public boolean supportsSameNameSiblings() {
        return this.sameNameSiblings;
    }

    public boolean supportsUpdates() {
        return this.updates;
    }

    public boolean supportsReferences() {
        return this.references;
    }

    public boolean supportsEvents() {
        return this.events;
    }

    public boolean supportsCreatingWorkspaces() {
        return this.creatingWorkspaces;
    }

    public boolean supportsLocks() {
        return this.locks;
    }

    public boolean supportsQueries() {
        return this.queries;
    }

    public boolean supportsSearches() {
        return this.searches;
    }

    public boolean supportsAutomaticGarbageCollection() {
        return this.autoGarbageCollection;
    }

    public RepositorySourceCapabilities withSameNameSiblings(boolean sameNameSiblings) {
        return new RepositorySourceCapabilities(sameNameSiblings, this.updates, this.events, this.creatingWorkspaces, this.references, this.locks, this.queries, this.searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withUpdates(boolean updates) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, updates, this.events, this.creatingWorkspaces, this.references, this.locks, this.queries, this.searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withEvents(boolean events) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, this.updates, events, this.creatingWorkspaces, this.references, this.locks, this.queries, this.searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withCreatingWorkspaces(boolean creatingWorkspaces) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, this.updates, this.events, creatingWorkspaces, this.references, this.locks, this.queries, this.searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withReferences(boolean references) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, this.updates, this.events, this.creatingWorkspaces, references, this.locks, this.queries, this.searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withLocks(boolean locks) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, this.updates, this.events, this.creatingWorkspaces, this.references, locks, this.queries, this.searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withQueries(boolean queries) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, this.updates, this.events, this.creatingWorkspaces, this.references, this.locks, queries, this.searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withSearches(boolean searches) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, this.updates, this.events, this.creatingWorkspaces, this.references, this.locks, this.queries, searches, this.autoGarbageCollection);
    }

    public RepositorySourceCapabilities withAutomaticGarbageCollection(boolean autoGarbageCollection) {
        return new RepositorySourceCapabilities(this.sameNameSiblings, this.updates, this.events, this.creatingWorkspaces, this.references, this.locks, this.queries, this.searches, autoGarbageCollection);
    }
}

