/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.observe;

import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.observe.ChangeObservers;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.ObservationBus;
import org.modeshape.graph.observe.Observer;

@ThreadSafe
public class LocalObservationBus
implements ObservationBus {
    private final ChangeObservers observers = new ChangeObservers();
    private static final Logger LOGGER = Logger.getLogger(LocalObservationBus.class);

    public void start() {
    }

    public boolean register(Observer observer) {
        if (observer == null) {
            return false;
        }
        return this.observers.register(observer);
    }

    public boolean unregister(Observer observer) {
        return this.observers.unregister(observer);
    }

    public void notify(Changes changes) {
        if (changes != null) {
            try {
                this.observers.broadcast(changes);
            }
            catch (RuntimeException t) {
                LOGGER.error((Throwable)t, GraphI18n.errorNotifyingObserver, new Object[]{t.getLocalizedMessage()});
            }
        }
    }

    public boolean hasObservers() {
        return !this.observers.isEmpty();
    }

    public void shutdown() {
        this.observers.shutdown();
    }
}

