/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.Location;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.process.JoinComponent;
import org.modeshape.graph.query.process.ProcessingComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MergeJoinComponent
extends JoinComponent {
    public MergeJoinComponent(QueryContext context, ProcessingComponent left, ProcessingComponent right, EquiJoinCondition condition, JoinType joinType) {
        super(context, left, right, condition, joinType);
    }

    public MergeJoinComponent(QueryContext context, ProcessingComponent left, ProcessingComponent right, ChildNodeJoinCondition condition, JoinType joinType) {
        super(context, left, right, condition, joinType);
    }

    public MergeJoinComponent(QueryContext context, ProcessingComponent left, ProcessingComponent right, SameNodeJoinCondition condition, JoinType joinType) {
        super(context, left, right, condition, joinType);
    }

    @Override
    public List<Object[]> execute() {
        QueryResults.Columns leftColumns = this.left().getColumns();
        QueryResults.Columns rightColumns = this.right().getColumns();
        JoinComponent.ValueSelector leftSelector = MergeJoinComponent.valueSelectorFor(this.left(), this.getJoinCondition());
        JoinComponent.ValueSelector rightSelector = MergeJoinComponent.valueSelectorFor(this.right(), this.getJoinCondition());
        Comparator<Object> comparator = MergeJoinComponent.comparatorFor(this.getContext(), this.left(), this.right(), this.getJoinCondition());
        JoinComponent.TupleMerger merger = MergeJoinComponent.createMerger(this.getColumns(), leftColumns, rightColumns);
        List<Object[]> leftTuples = this.left().execute();
        List<Object[]> rightTuples = this.right().execute();
        ArrayList<Object[]> tuples = new ArrayList<Object[]>(leftTuples.size() * rightTuples.size());
        Iterator<Object[]> leftIter = leftTuples.iterator();
        Iterator<Object[]> rightIter = rightTuples.iterator();
        Object[] leftTuple = leftIter.next();
        Object[] rightTuple = rightIter.next();
        Object[] nextLeftTuple = null;
        Object[] nextRightTuple = null;
        while (true) {
            Object leftValue = leftSelector.evaluate(leftTuple);
            Object rightValue = rightSelector.evaluate(rightTuple);
            int compare = comparator.compare(leftValue, rightValue);
            while (compare == 0) {
                Object[] result = merger.merge(leftTuple, rightTuple);
                tuples.add(result);
                if (nextRightTuple == null) {
                    nextRightTuple = rightIter.next();
                    while (this.isSameTuple(rightColumns, nextRightTuple, rightTuple)) {
                        nextRightTuple = rightIter.next();
                    }
                }
                if ((compare = comparator.compare(leftValue = leftSelector.evaluate(leftTuple), rightValue = rightSelector.evaluate(nextRightTuple))) == 0) {
                    rightTuple = nextRightTuple;
                    nextRightTuple = null;
                    continue;
                }
                if (compare > 0) {
                    rightTuple = nextRightTuple;
                    nextRightTuple = null;
                    compare = 0;
                    break;
                }
                nextLeftTuple = leftIter.next();
                while (this.isSameTuple(leftColumns, nextLeftTuple, leftTuple)) {
                    nextLeftTuple = leftIter.next();
                }
                leftValue = leftSelector.evaluate(nextLeftTuple);
                compare = comparator.compare(leftValue, rightValue = rightSelector.evaluate(rightTuple));
                if (compare == 0) {
                    leftTuple = nextLeftTuple;
                    nextLeftTuple = null;
                    continue;
                }
                leftTuple = nextLeftTuple;
                rightTuple = nextRightTuple;
                nextLeftTuple = null;
                nextRightTuple = null;
                compare = 0;
                break;
            }
            if (compare < 0) {
                if (!leftIter.hasNext()) break;
                leftTuple = leftIter.next();
            }
            if (compare <= 0) continue;
            if (!rightIter.hasNext()) break;
            rightTuple = rightIter.next();
        }
        return tuples;
    }

    protected final boolean isSameTuple(QueryResults.Columns columns, Object[] tuple1, Object[] tuple2) {
        for (int i = columns.getColumnCount(); i != columns.getLocationCount(); ++i) {
            Location location = (Location)tuple1[i];
            Location location2 = (Location)tuple2[i];
            if (location.isSame(location2)) continue;
            return false;
        }
        return true;
    }
}

