/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.util.Encode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletInputMessage
implements HttpRequest {
    protected HttpHeaders httpHeaders;
    protected HttpServletRequest request;
    protected CountDownLatch latch;
    protected long suspendTimeout;
    protected SynchronousDispatcher dispatcher;
    protected HttpResponse httpResponse;
    protected boolean suspended;
    protected UriInfo uri;
    protected String httpMethod;
    protected String preProcessedPath;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected AbstractAsynchronousResponse asynchronousResponse;
    protected InputStream overridenStream;

    public HttpServletInputMessage(HttpServletRequest request, HttpResponse httpResponse, HttpHeaders httpHeaders, UriInfo uri, String httpMethod, SynchronousDispatcher dispatcher) {
        this.request = request;
        this.dispatcher = dispatcher;
        this.httpResponse = httpResponse;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.preProcessedPath = uri.getPath(false);
    }

    public MultivaluedMap<String, String> getPutFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf("application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm(this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getPutDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.request.getAttribute(attribute);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    @Override
    public MultivaluedMap<String, String> getFormParameters() {
        if (this.request.getMethod().equals("PUT")) {
            return this.getPutFormParameters();
        }
        if (this.formParameters != null) {
            return this.formParameters;
        }
        this.formParameters = Encode.encode(this.getDecodedFormParameters());
        return this.formParameters;
    }

    @Override
    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.request.getMethod().equals("PUT")) {
            return this.getPutDecodedFormParameters();
        }
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = new MultivaluedMapImpl<String, String>();
        Map params = this.request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            MultivaluedMap<String, String> queryParams = this.uri.getQueryParameters();
            List queryValues = (List)queryParams.get(name);
            if (queryValues == null) {
                for (String val : values) {
                    this.decodedFormParameters.add(name, val);
                }
                continue;
            }
            for (String val : values) {
                if (queryValues.contains(val)) continue;
                this.decodedFormParameters.add(name, val);
            }
        }
        return this.decodedFormParameters;
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public InputStream getInputStream() {
        if (this.overridenStream != null) {
            return this.overridenStream;
        }
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.overridenStream = stream;
    }

    @Override
    public UriInfo getUri() {
        return this.uri;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getPreprocessedPath() {
        return this.preProcessedPath;
    }

    @Override
    public void setPreprocessedPath(String path) {
        this.preProcessedPath = path;
    }

    @Override
    public AsynchronousResponse createAsynchronousResponse(long suspendTimeout) {
        this.suspended = true;
        this.latch = new CountDownLatch(1);
        this.suspendTimeout = suspendTimeout;
        this.asynchronousResponse = new AbstractAsynchronousResponse(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setResponse(Response response) {
                try {
                    this.setupResponse((ServerResponse)response);
                    HttpServletInputMessage.this.dispatcher.asynchronousDelivery(HttpServletInputMessage.this, HttpServletInputMessage.this.httpResponse, response);
                }
                finally {
                    HttpServletInputMessage.this.latch.countDown();
                }
            }
        };
        return this.asynchronousResponse;
    }

    @Override
    public AsynchronousResponse getAsynchronousResponse() {
        return this.asynchronousResponse;
    }

    @Override
    public boolean isInitial() {
        return true;
    }

    public boolean isTimeout() {
        return false;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public void initialRequestThreadFinished() {
        if (this.latch == null) {
            return;
        }
        try {
            this.latch.await(this.suspendTimeout + 100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

