/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.dialect.derby.DerbyDdlParser;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlParser;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;

@Immutable
public class DdlParsers {
    public static final List<DdlParser> BUILTIN_PARSERS;
    private List<DdlParser> parsers;

    public DdlParsers() {
        this.parsers = BUILTIN_PARSERS;
    }

    public DdlParsers(List<DdlParser> parsers) {
        this.parsers = parsers != null && !parsers.isEmpty() ? parsers : BUILTIN_PARSERS;
    }

    public AstNode parse(String ddl, String fileName) throws ParsingException {
        assert (ddl != null);
        LinkedList<ScoredParser> scoredParsers = new LinkedList<ScoredParser>();
        for (DdlParser parser : this.parsers) {
            DdlParserScorer scorer = new DdlParserScorer();
            try {
                Object scoreResult = parser.score(ddl, fileName, scorer);
                scoredParsers.add(new ScoredParser(parser, scorer, scoreResult));
            }
            catch (Throwable t) {}
        }
        if (!scoredParsers.isEmpty()) {
            Collections.sort(scoredParsers);
        } else {
            for (DdlParser parser : this.parsers) {
                scoredParsers.add(new ScoredParser(parser, new DdlParserScorer(), null));
            }
        }
        AstNode astRoot = null;
        Throwable firstException = null;
        for (ScoredParser scoredParser : scoredParsers) {
            try {
                astRoot = new AstNode(StandardDdlLexicon.STATEMENTS_CONTAINER);
                astRoot.setProperty(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.UNSTRUCTURED);
                DdlParser parser = scoredParser.getParser();
                parser.parse(ddl, astRoot, scoredParser.getScoringResult());
                astRoot.setProperty(StandardDdlLexicon.PARSER_ID, (Object)parser.getId());
                return astRoot;
            }
            catch (ParsingException t) {
                if (firstException != null) continue;
                firstException = t;
            }
            catch (RuntimeException t) {
                if (firstException != null) continue;
                firstException = t;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        throw new ParsingException(new Position(-1, 1, 0), DdlSequencerI18n.errorParsingDdlContent.text(new Object[0]));
    }

    static {
        ArrayList<StandardDdlParser> parsers = new ArrayList<StandardDdlParser>();
        parsers.add(new StandardDdlParser());
        parsers.add(new OracleDdlParser());
        parsers.add(new DerbyDdlParser());
        parsers.add(new PostgresDdlParser());
        BUILTIN_PARSERS = Collections.unmodifiableList(parsers);
    }

    protected static class ScoredParser
    implements Comparable<ScoredParser> {
        private final DdlParserScorer scorer;
        private final DdlParser parser;
        private final Object scoringResult;

        protected ScoredParser(DdlParser parser, DdlParserScorer scorer, Object scoringResult) {
            this.parser = parser;
            this.scorer = scorer;
            this.scoringResult = scoringResult;
            assert (this.parser != null);
            assert (this.scorer != null);
        }

        public DdlParser getParser() {
            return this.parser;
        }

        public DdlParserScorer getScorer() {
            return this.scorer;
        }

        public Object getScoringResult() {
            return this.scoringResult;
        }

        @Override
        public int compareTo(ScoredParser that) {
            if (that == null) {
                return 1;
            }
            return that.getScorer().getScore() - this.getScorer().getScore();
        }
    }
}

