/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.tinytree.TinyBuilder;

public class XdmDestination
implements Destination {
    TinyBuilder builder = new TinyBuilder();

    public void setBaseURI(URI baseURI) {
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.builder.setBaseURI(baseURI.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.builder.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err.getMessage());
        }
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        return this.builder;
    }

    public XdmNode getXdmNode() {
        return (XdmNode)XdmValue.wrap((ValueRepresentation)this.builder.getCurrentRoot());
    }

    public void reset() {
        this.builder = new TinyBuilder();
    }
}

