/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package com.metamatrix.metamodels.wsdl.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDSchema;
import com.metamatrix.metamodels.wsdl.Definitions;
import com.metamatrix.metamodels.wsdl.Documentation;
import com.metamatrix.metamodels.wsdl.Element;
import com.metamatrix.metamodels.wsdl.ElementOwner;
import com.metamatrix.metamodels.wsdl.NamespaceDeclaration;
import com.metamatrix.metamodels.wsdl.NamespaceDeclarationOwner;
import com.metamatrix.metamodels.wsdl.Types;
import com.metamatrix.metamodels.wsdl.WsdlPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Types</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.TypesImpl#getDocumentation <em>Documentation</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.TypesImpl#getDeclaredNamespaces <em>Declared Namespaces</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.TypesImpl#getElements <em>Elements</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.TypesImpl#getDefinitions <em>Definitions</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.TypesImpl#getSchemas <em>Schemas</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class TypesImpl extends EObjectImpl implements Types {

    /**
     * The cached value of the '{@link #getDocumentation() <em>Documentation</em>}' containment reference. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @see #getDocumentation()
     * @generated
     * @ordered
     */
    protected Documentation documentation = null;

    /**
     * The cached value of the '{@link #getDeclaredNamespaces() <em>Declared Namespaces</em>}' containment reference list. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getDeclaredNamespaces()
     * @generated
     * @ordered
     */
    protected EList declaredNamespaces = null;

    /**
     * The cached value of the '{@link #getElements() <em>Elements</em>}' containment reference list. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getElements()
     * @generated
     * @ordered
     */
    protected EList elements = null;

    /**
     * The cached value of the '{@link #getSchemas() <em>Schemas</em>}' containment reference list. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getSchemas()
     * @generated
     * @ordered
     */
    protected EList schemas = null;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected TypesImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return WsdlPackage.eINSTANCE.getTypes();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public Documentation getDocumentation() {
        return documentation;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public NotificationChain basicSetDocumentation( Documentation newDocumentation,
                                                    NotificationChain msgs ) {
        Documentation oldDocumentation = documentation;
        documentation = newDocumentation;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, WsdlPackage.TYPES__DOCUMENTATION,
                                                                   oldDocumentation, newDocumentation);
            if (msgs == null) msgs = notification;
            else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setDocumentation( Documentation newDocumentation ) {
        if (newDocumentation != documentation) {
            NotificationChain msgs = null;
            if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                              WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                              Documentation.class,
                                                                                              msgs);
            if (newDocumentation != null) msgs = ((InternalEObject)newDocumentation).eInverseAdd(this,
                                                                                                 WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                                 Documentation.class,
                                                                                                 msgs);
            msgs = basicSetDocumentation(newDocumentation, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                          WsdlPackage.TYPES__DOCUMENTATION, newDocumentation,
                                                                          newDocumentation));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getDeclaredNamespaces() {
        if (declaredNamespaces == null) {
            declaredNamespaces = new EObjectContainmentWithInverseEList(NamespaceDeclaration.class, this,
                                                                        WsdlPackage.TYPES__DECLARED_NAMESPACES,
                                                                        WsdlPackage.NAMESPACE_DECLARATION__OWNER);
        }
        return declaredNamespaces;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getElements() {
        if (elements == null) {
            elements = new EObjectContainmentWithInverseEList(Element.class, this, WsdlPackage.TYPES__ELEMENTS,
                                                              WsdlPackage.ELEMENT__ELEMENT_OWNER);
        }
        return elements;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public Definitions getDefinitions() {
        if (eContainerFeatureID != WsdlPackage.TYPES__DEFINITIONS) return null;
        return (Definitions)eContainer;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setDefinitions( Definitions newDefinitions ) {
        if (newDefinitions != eContainer || (eContainerFeatureID != WsdlPackage.TYPES__DEFINITIONS && newDefinitions != null)) {
            if (EcoreUtil.isAncestor(this, newDefinitions)) throw new IllegalArgumentException(
                                                                                               "Recursive containment not allowed for " + toString()); //$NON-NLS-1$
            NotificationChain msgs = null;
            if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
            if (newDefinitions != null) msgs = ((InternalEObject)newDefinitions).eInverseAdd(this,
                                                                                             WsdlPackage.DEFINITIONS__TYPES,
                                                                                             Definitions.class,
                                                                                             msgs);
            msgs = eBasicSetContainer((InternalEObject)newDefinitions, WsdlPackage.TYPES__DEFINITIONS, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET, WsdlPackage.TYPES__DEFINITIONS,
                                                                          newDefinitions, newDefinitions));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getSchemas() {
        if (schemas == null) {
            schemas = new EObjectContainmentEList(XSDSchema.class, this, WsdlPackage.TYPES__SCHEMAS);
        }
        return schemas;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd( InternalEObject otherEnd,
                                          int featureID,
                                          Class baseClass,
                                          NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.TYPES__DOCUMENTATION:
                    if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                                      EOPPOSITE_FEATURE_BASE
                                                                                                      - WsdlPackage.TYPES__DOCUMENTATION,
                                                                                                      null,
                                                                                                      msgs);
                    return basicSetDocumentation((Documentation)otherEnd, msgs);
                case WsdlPackage.TYPES__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicAdd(otherEnd, msgs);
                case WsdlPackage.TYPES__ELEMENTS:
                    return ((InternalEList)getElements()).basicAdd(otherEnd, msgs);
                case WsdlPackage.TYPES__DEFINITIONS:
                    if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, WsdlPackage.TYPES__DEFINITIONS, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove( InternalEObject otherEnd,
                                             int featureID,
                                             Class baseClass,
                                             NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.TYPES__DOCUMENTATION:
                    return basicSetDocumentation(null, msgs);
                case WsdlPackage.TYPES__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicRemove(otherEnd, msgs);
                case WsdlPackage.TYPES__ELEMENTS:
                    return ((InternalEList)getElements()).basicRemove(otherEnd, msgs);
                case WsdlPackage.TYPES__DEFINITIONS:
                    return eBasicSetContainer(null, WsdlPackage.TYPES__DEFINITIONS, msgs);
                case WsdlPackage.TYPES__SCHEMAS:
                    return ((InternalEList)getSchemas()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainer( NotificationChain msgs ) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case WsdlPackage.TYPES__DEFINITIONS:
                    return eContainer.eInverseRemove(this, WsdlPackage.DEFINITIONS__TYPES, Definitions.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object eGet( EStructuralFeature eFeature,
                        boolean resolve ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.TYPES__DOCUMENTATION:
                return getDocumentation();
            case WsdlPackage.TYPES__DECLARED_NAMESPACES:
                return getDeclaredNamespaces();
            case WsdlPackage.TYPES__ELEMENTS:
                return getElements();
            case WsdlPackage.TYPES__DEFINITIONS:
                return getDefinitions();
            case WsdlPackage.TYPES__SCHEMAS:
                return getSchemas();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eSet( EStructuralFeature eFeature,
                      Object newValue ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.TYPES__DOCUMENTATION:
                setDocumentation((Documentation)newValue);
                return;
            case WsdlPackage.TYPES__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                getDeclaredNamespaces().addAll((Collection)newValue);
                return;
            case WsdlPackage.TYPES__ELEMENTS:
                getElements().clear();
                getElements().addAll((Collection)newValue);
                return;
            case WsdlPackage.TYPES__DEFINITIONS:
                setDefinitions((Definitions)newValue);
                return;
            case WsdlPackage.TYPES__SCHEMAS:
                getSchemas().clear();
                getSchemas().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eUnset( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.TYPES__DOCUMENTATION:
                setDocumentation((Documentation)null);
                return;
            case WsdlPackage.TYPES__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                return;
            case WsdlPackage.TYPES__ELEMENTS:
                getElements().clear();
                return;
            case WsdlPackage.TYPES__DEFINITIONS:
                setDefinitions((Definitions)null);
                return;
            case WsdlPackage.TYPES__SCHEMAS:
                getSchemas().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean eIsSet( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.TYPES__DOCUMENTATION:
                return documentation != null;
            case WsdlPackage.TYPES__DECLARED_NAMESPACES:
                return declaredNamespaces != null && !declaredNamespaces.isEmpty();
            case WsdlPackage.TYPES__ELEMENTS:
                return elements != null && !elements.isEmpty();
            case WsdlPackage.TYPES__DEFINITIONS:
                return getDefinitions() != null;
            case WsdlPackage.TYPES__SCHEMAS:
                return schemas != null && !schemas.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eBaseStructuralFeatureID( int derivedFeatureID,
                                         Class baseClass ) {
        if (baseClass == NamespaceDeclarationOwner.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.TYPES__DECLARED_NAMESPACES:
                    return WsdlPackage.NAMESPACE_DECLARATION_OWNER__DECLARED_NAMESPACES;
                default:
                    return -1;
            }
        }
        if (baseClass == ElementOwner.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.TYPES__ELEMENTS:
                    return WsdlPackage.ELEMENT_OWNER__ELEMENTS;
                default:
                    return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eDerivedStructuralFeatureID( int baseFeatureID,
                                            Class baseClass ) {
        if (baseClass == NamespaceDeclarationOwner.class) {
            switch (baseFeatureID) {
                case WsdlPackage.NAMESPACE_DECLARATION_OWNER__DECLARED_NAMESPACES:
                    return WsdlPackage.TYPES__DECLARED_NAMESPACES;
                default:
                    return -1;
            }
        }
        if (baseClass == ElementOwner.class) {
            switch (baseFeatureID) {
                case WsdlPackage.ELEMENT_OWNER__ELEMENTS:
                    return WsdlPackage.TYPES__ELEMENTS;
                default:
                    return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

} // TypesImpl
