/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.AnyElementObjectImpl;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.objecteditor.XChildrenEditor;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;

public class AnyElementForm
extends ExpandableForm {
    private XModelObject xmo;
    private XTable tableEditor = new XTable();
    TableProviderImpl tableProvider = new TableProviderImpl();
    CommandBar bar = new CommandBar();
    private IWidgetSettings settings = new WhiteSettings();
    private long timeStamp = -1L;

    public AnyElementForm() {
        this.setCollapsable(Boolean.TRUE);
        this.tableEditor.setTableProvider(this.tableProvider);
        this.bar.setCommands(new String[]{XChildrenEditor.ADD, XChildrenEditor.EDIT, XChildrenEditor.DELETE});
        this.bar.addCommandBarListener(new CommandBarListenerImpl());
        this.bar.getLayout().direction = 512;
        this.bar.setWidgetSettings(this.settings);
        this.bar.getLayout().buttonWidth = 80;
    }

    public void dispose() {
        super.dispose();
        if (this.tableEditor != null) {
            this.tableEditor.dispose();
            this.tableEditor = null;
        }
        if (this.tableProvider != null) {
            this.tableProvider.dispose();
            this.tableProvider = null;
        }
    }

    protected Control createClientArea(Composite parent, IWidgetSettings settings) {
        GridData gd;
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(1);
        settings.setupControl((Control)composite);
        GridLayout layout = new GridLayout(2, Boolean.FALSE.booleanValue());
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        if (this.xmo == null) {
            return composite;
        }
        String description = "";
        if (description != null && description.length() > 0) {
            Label label = new Label(composite, 64);
            settings.setupControl((Control)label);
            label.setText(description);
            gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        Composite c = new Composite(composite, 0);
        settings.setupControl((Control)c);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        c.setLayout((Layout)layout2);
        Control control = this.tableEditor.createControl(c);
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        control = this.bar.createControl(c);
        gd = new GridData(1040);
        control.setLayoutData((Object)gd);
        this.tableEditor.update();
        this.tableEditor.getViewer().setColumnProperties(this.tableProvider.header);
        this.tableEditor.getViewer().setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.tableEditor.getTable()), new TextCellEditor((Composite)this.tableEditor.getTable())});
        this.tableEditor.getViewer().setCellModifier((ICellModifier)new CellModifier());
        this.tableEditor.getViewer().addSelectionChangedListener((ISelectionChangedListener)new SCL());
        this.updateCommandBar();
        return composite;
    }

    public void initialize(Object model) {
        String heading = "Attributes";
        this.setHeadingText(heading);
        if (!(model instanceof XModelObject)) {
            ModelUIPlugin.getPluginLog().logInfo("Error to create form " + heading + ". Model object cannot be null.", (Throwable)new Exception());
            return;
        }
        this.xmo = (XModelObject)model;
        this.updateAttributes();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void update() {
        long ts;
        long l = ts = this.xmo == null ? -1L : this.xmo.getTimeStamp();
        if (ts == this.timeStamp) {
            return;
        }
        this.timeStamp = ts;
        this.updateAttributes();
        this.tableEditor.update();
    }

    void updateAttributes() {
        if (this.tableProvider == null) {
            return;
        }
        if (this.xmo == null) {
            this.tableProvider.attributes = null;
        } else {
            String attrs = this.xmo.getAttributeValue("attributes");
            StringTokenizer st = new StringTokenizer(attrs, ";");
            int length = st.countTokens();
            String[][] as = new String[length][2];
            int i = 0;
            while (i < length) {
                String t = st.nextToken();
                int k = t.indexOf(61);
                String n = k < 0 ? "" : t.substring(0, k);
                String v = t.substring(k + 1);
                as[i][0] = n;
                as[i][1] = v;
                ++i;
            }
            this.tableProvider.attributes = as;
        }
    }

    void commitAttributes() throws XModelException {
        if (this.xmo == null || this.tableProvider == null || this.tableProvider.attributes == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.tableProvider.attributes.length) {
            String n = this.tableProvider.attributes[i][0].trim();
            if (n.length() != 0) {
                String v = this.tableProvider.attributes[i][1].trim();
                if (sb.length() > 0) {
                    sb.append(AnyElementObjectImpl.SEPARATOR);
                }
                sb.append(n).append('=').append(v);
            }
            ++i;
        }
        String v = sb.toString();
        this.xmo.getModel().editObjectAttribute(this.xmo, "attributes", v);
    }

    void updateCommandBar() {
        boolean enabled = this.xmo != null && this.xmo.isObjectEditable();
        int[] is = this.tableEditor.getTable().getSelectionIndices();
        int selected = is == null ? 0 : is.length;
        this.bar.setEnabled(XChildrenEditor.EDIT, enabled && selected == 1);
        this.bar.setEnabled(XChildrenEditor.DELETE, enabled && selected > 0);
        this.bar.setEnabled(XChildrenEditor.ADD, enabled);
    }

    void add() {
        XActionInvoker.invoke((String)"CreateActions.CreateAttribute", (XModelObject)this.xmo, (Properties)new Properties());
    }

    void edit() {
        if (this.tableEditor.getTable() == null || this.tableEditor.getTable().isDisposed()) {
            return;
        }
        int i = this.tableEditor.getTable().getSelectionIndex();
        if (i < 0) {
            return;
        }
        String name = this.tableProvider.getValueAt(i, 0);
        Properties p = new Properties();
        p.setProperty("name", name);
        XActionInvoker.invoke((String)"AnyElementNew", (String)"EditActions.EditAttribute", (XModelObject)this.xmo, (Properties)p);
    }

    void delete() throws XModelException {
        if (this.tableEditor.getTable() == null || this.tableEditor.getTable().isDisposed()) {
            return;
        }
        int[] is = this.tableEditor.getTable().getSelectionIndices();
        if (is == null || is.length == 0) {
            return;
        }
        String name = this.tableProvider.getValueAt(is[0], 0);
        ServiceDialog d = this.xmo.getModel().getService();
        String message = null;
        message = is.length == 1 ? MessageFormat.format("Delete attribute {0}?", name) : MessageFormat.format("Delete {0} attributes?", is.length);
        int q = d.showDialog("Delete", message, new String[]{"OK", "Cancel"}, null, 0);
        if (q != 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.tableProvider.attributes.length) {
            String n;
            boolean a = true;
            int j = 0;
            while (j < is.length && a) {
                if (is[j] == i) {
                    a = false;
                }
                ++j;
            }
            if (a && (n = this.tableProvider.attributes[i][0].trim()).length() != 0) {
                String v = this.tableProvider.attributes[i][1].trim();
                if (sb.length() > 0) {
                    sb.append(AnyElementObjectImpl.SEPARATOR);
                }
                sb.append(n).append('=').append(v);
            }
            ++i;
        }
        String v = sb.toString();
        this.xmo.getModel().editObjectAttribute(this.xmo, "attributes", v);
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (!"value".equals(property)) {
                return false;
            }
            return AnyElementForm.this.xmo != null && AnyElementForm.this.xmo.isObjectEditable() && this.getColumn(property) >= 0;
        }

        public Object getValue(Object element, String property) {
            int r = (Integer)element;
            int c = this.getColumn(property);
            return c < 0 ? "" : AnyElementForm.this.tableProvider.getValueAt(r, c);
        }

        int getColumn(String property) {
            int c = 0;
            while (c < AnyElementForm.this.tableProvider.header.length) {
                if (property.equals(AnyElementForm.this.tableProvider.header[c])) {
                    return c;
                }
                ++c;
            }
            return -1;
        }

        public void modify(Object element, String property, Object value) {
            int r = (Integer)((TableItem)element).getData();
            int c = this.getColumn(property);
            if (c < 0) {
                return;
            }
            String oldValue = AnyElementForm.this.tableProvider.getValueAt(r, c);
            if (oldValue != null && oldValue.equals(value)) {
                return;
            }
            AnyElementForm.this.tableProvider.attributes[r][c] = "" + value;
            try {
                AnyElementForm.this.commitAttributes();
            }
            catch (XModelException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    class CommandBarListenerImpl
    implements CommandBarListener {
        CommandBarListenerImpl() {
        }

        public void action(String command) throws XModelException {
            if (XChildrenEditor.ADD.equals(command)) {
                AnyElementForm.this.add();
            } else if (XChildrenEditor.EDIT.equals(command)) {
                AnyElementForm.this.edit();
            } else if (XChildrenEditor.DELETE.equals(command)) {
                AnyElementForm.this.delete();
            }
        }
    }

    class SCL
    implements ISelectionChangedListener {
        SCL() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AnyElementForm.this.updateCommandBar();
        }
    }

    class TableProviderImpl
    implements XTableProvider {
        String[] header = new String[]{"Name", "Value"};
        String[][] attributes = null;

        TableProviderImpl() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.attributes == null ? 0 : this.attributes.length;
        }

        public String getColumnName(int c) {
            return this.header[c];
        }

        public String getValueAt(int r, int c) {
            return this.attributes == null ? null : this.attributes[r][c];
        }

        public Object getDataAt(int r) {
            return r;
        }

        public Color getColor(int r) {
            return null;
        }

        public int getWidthHint(int c) {
            return 10;
        }

        public void dispose() {
        }
    }
}

