/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.special;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ui.wizards.special.DefaultSpecialWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressPart
implements IRunnableContext {
    DefaultSpecialWizard wizard = null;
    Shell shell = null;
    private ProgressMonitorPart progressMonitorPart;
    private boolean lockedUI = false;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private long activeRunningOperations = 0L;
    private static final String FOCUS_CONTROL = "focusControl";

    public ProgressPart(Shell shell, DefaultSpecialWizard wizard) {
        this.shell = shell;
        this.wizard = wizard;
    }

    Shell getShell() {
        return this.shell;
    }

    protected void createProgressMonitorPart(Composite composite) {
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = this.createProgressMonitorPart(composite, pmlayout);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
    }

    private Object aboutToStart(boolean enableCancelButton) {
        Map<Object, Object> savedState = null;
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            this.setWaitCursor();
            savedState = this.saveUIState(enableCancelButton);
            this.saveFocus(savedState, focusControl);
        }
        return savedState;
    }

    private void setWaitCursor() {
        Display d = this.getShell().getDisplay();
        this.waitCursor = new Cursor((Device)d, 1);
        this.setDisplayCursor(this.waitCursor);
        this.arrowCursor = new Cursor((Device)d, 0);
    }

    private void saveFocus(Map<Object, Object> state, Control focusControl) {
        if (focusControl != null) {
            state.put(FOCUS_CONTROL, focusControl);
        }
    }

    private void setDisplayCursor(Cursor c) {
        Shell[] shells = this.getShell().getDisplay().getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    private Map<Object, Object> saveUIState(boolean keepCancelEnabled) {
        HashMap<Object, Object> savedState = new HashMap<Object, Object>(10);
        return savedState;
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new ProgressMonitorPart(composite, (Layout)pmlayout, -1){
            String currentTask;
            {
                this.currentTask = null;
            }

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                if (!ProgressPart.this.lockedUI) {
                    Dialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, reason, this.currentTask);
                }
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (!ProgressPart.this.lockedUI) {
                    Dialog.getBlockedHandler().clearBlocked();
                }
            }

            public void beginTask(String name, int totalWork) {
                super.beginTask(name, totalWork);
                this.currentTask = name;
            }

            public void setTaskName(String name) {
                super.setTaskName(name);
                this.currentTask = name;
            }

            public void subTask(String name) {
                super.subTask(name);
                if (this.currentTask == null) {
                    this.currentTask = name;
                }
            }
        };
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = null;
        if (this.activeRunningOperations == 0L) {
            state = this.aboutToStart(fork && cancelable);
        }
        ++this.activeRunningOperations;
        try {
            if (!fork) {
                this.lockedUI = true;
            }
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
            this.lockedUI = false;
        }
        finally {
            --this.activeRunningOperations;
            if (state != null) {
                this.stopped(state);
            }
        }
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null) {
            this.wizard.needsProgressMonitor();
            Map state = (Map)savedState;
            this.setDisplayCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    public void dispose() {
        if (this.progressMonitorPart != null) {
            this.progressMonitorPart.dispose();
            this.progressMonitorPart = null;
        }
    }
}

