/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class FileRecord
extends AbstractPMDRecord {
    private AbstractPMDRecord[] children;
    private IResource resource;
    private PackageRecord parent;
    private int numberOfLOC;
    private int numberOfMethods;

    public FileRecord(IResource iResource) {
        this(iResource, null);
    }

    public FileRecord(IResource iResource, PackageRecord packageRecord) {
        if (iResource == null) {
            throw new IllegalArgumentException("javaResouce cannot be null");
        }
        this.resource = iResource;
        this.parent = packageRecord;
        this.numberOfLOC = 0;
        this.numberOfMethods = 0;
        this.children = this.createChildren();
    }

    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void updateChildren() {
        this.children = this.createChildren();
    }

    protected final AbstractPMDRecord[] createChildren() {
        AbstractPMDRecord[] abstractPMDRecordArray = AbstractPMDRecord.EMPTY_RECORDS;
        try {
            List<IMarker> list = Arrays.asList(this.findMarkers());
            Iterator<IMarker> iterator = list.iterator();
            HashMap<Object, MarkerRecord> hashMap = new HashMap<Object, MarkerRecord>();
            while (iterator.hasNext()) {
                IMarker iMarker = iterator.next();
                MarkerRecord markerRecord = (MarkerRecord)hashMap.get(iMarker.getAttribute("rulename"));
                if (markerRecord == null) {
                    markerRecord = new MarkerRecord(this, (String)iMarker.getAttribute("rulename"), (Integer)iMarker.getAttribute("pmd_priority"));
                    markerRecord.addViolation(iMarker);
                    hashMap.put(iMarker.getAttribute("rulename"), markerRecord);
                    continue;
                }
                markerRecord.addViolation(iMarker);
            }
            abstractPMDRecordArray = hashMap.values().toArray(new MarkerRecord[hashMap.size()]);
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.core_exception" + this.toString(), coreException);
        }
        return abstractPMDRecordArray;
    }

    public boolean hasMarkers() {
        IMarker[] iMarkerArray = this.findMarkers();
        return iMarkerArray != null && iMarkerArray.length > 0;
    }

    public final IMarker[] findMarkers() {
        IMarker[] iMarkerArray = new IMarker[]{};
        try {
            if (this.resource.isAccessible()) {
                iMarkerArray = this.resource.findMarkers("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true, 2);
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), coreException);
        }
        return iMarkerArray;
    }

    public IMarker[] findDFAMarkers() {
        IMarker[] iMarkerArray = new IMarker[]{};
        try {
            if (this.resource.isAccessible()) {
                iMarkerArray = this.resource.findMarkers("net.sourceforge.pmd.eclipse.plugin.pmdDFAMarker", true, 2);
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), coreException);
        }
        return iMarkerArray;
    }

    public IMarker[] findMarkersByAttribute(String string, Object object) {
        IMarker[] iMarkerArray = this.findMarkers();
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        try {
            int n = 0;
            while (n < iMarkerArray.length) {
                Object object2 = iMarkerArray[n].getAttribute(string);
                if (object2 != null && object2.equals(object)) {
                    arrayList.add(iMarkerArray[n]);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), coreException);
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    public void calculateLinesOfCode() {
        if (this.resource.isAccessible()) {
            int n = 0;
            String string = this.resourceToString(this.resource);
            int n2 = string.indexOf(123);
            if (n2 != -1) {
                String string2 = string.substring(n2 + 1, string.length() - 1).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    if (string3.length() > 0 && string3.startsWith("/*")) {
                        while (string3.indexOf("*/") == -1) {
                            string3 = stringTokenizer.nextToken().trim();
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken().trim();
                        }
                    }
                    if (string3.startsWith("//")) continue;
                    ++n;
                }
            }
            this.numberOfLOC = n;
        }
    }

    public int getLOC() {
        return this.numberOfLOC;
    }

    /*
     * Exception decompiling
     */
    protected String resourceToString(IResource var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 166->169)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void calculateNumberOfMethods() {
        if (this.resource.isAccessible()) {
            IJavaElement iJavaElement = JavaCore.create((IResource)this.resource);
            ArrayList<IMethod> arrayList = new ArrayList<IMethod>();
            if (iJavaElement instanceof ICompilationUnit) {
                try {
                    IType[] iTypeArray = ((ICompilationUnit)iJavaElement).getTypes();
                    int n = 0;
                    while (n < iTypeArray.length) {
                        if (iTypeArray[n] instanceof IType) {
                            arrayList.addAll(Arrays.asList(iTypeArray[n].getMethods()));
                        }
                        ++n;
                    }
                }
                catch (JavaModelException javaModelException) {
                    PMDPlugin.getDefault().logError("message.error.javamodel_exception" + this.toString(), javaModelException);
                }
            }
            if (!arrayList.isEmpty()) {
                this.numberOfMethods = arrayList.size();
            }
        }
    }

    public int getNumberOfMethods() {
        return this.numberOfMethods;
    }

    public AbstractPMDRecord addResource(IResource iResource) {
        return null;
    }

    public AbstractPMDRecord removeResource(IResource iResource) {
        return null;
    }

    public String getName() {
        return this.resource.getName();
    }

    public int getResourceType() {
        return 1;
    }

    public int getNumberOfViolationsToPriority(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.children.length) {
            n2 += this.children[n3].getNumberOfViolationsToPriority(n, false);
            ++n3;
        }
        return n2;
    }
}

