/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class ActionButtonControl
implements IPropertyFieldEditor {
    private Composite composite;
    private ArrayList<ButtonWrapper> buttons;
    private IPropertyEditor propertyEditor;
    private IActionProvider actionProvider;
    private IWidgetSettings settings = DefaultSettings.getDefault();

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.initialize();
    }

    public Control getControl() {
        return this.composite;
    }

    public Control createControl(Composite parent) {
        if (this.composite == null) {
            this.composite = new Composite(parent, 0);
            this.composite.setBackgroundMode(1);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 5;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            int i = 0;
            while (i < this.buttons.size()) {
                this.createButton(this.composite, this.buttons.get(i));
                ++i;
            }
        }
        return this.composite;
    }

    private Control createButton(Composite parent, ButtonWrapper buttonWrapper) {
        int style = this.getSettings().getStyle("Button.Style");
        if (style == -1) {
            style = 0;
        }
        if (style == 0) {
            style = 8;
        }
        Control buttonControl = buttonWrapper.createControl(parent, style);
        Color fg = this.getSettings().getColor("Button.Foreground");
        Font font = this.getSettings().getFont("Button.Font");
        buttonControl.setForeground(fg);
        buttonControl.setFont(font);
        GridData gd = new GridData();
        gd.widthHint = this.convertHorizontalDLUsToPixels(buttonControl, 61);
        buttonControl.setLayoutData((Object)gd);
        return buttonControl;
    }

    private void initialize() {
        if (this.propertyEditor != null) {
            this.actionProvider = (IActionProvider)this.propertyEditor.getAdapter(IActionProvider.class);
            if (this.actionProvider == null) {
                return;
            }
            List<IAction> actions = Arrays.asList(this.actionProvider.getActions());
            Iterator<IAction> i = actions.iterator();
            this.buttons = new ArrayList();
            while (i.hasNext()) {
                ButtonWrapper buttonWrapper = new ButtonWrapper(i.next());
                this.buttons.add(buttonWrapper);
            }
        }
    }

    public IWidgetSettings getSettings() {
        return this.settings;
    }

    public void setSettings(IWidgetSettings settings) {
        this.settings = settings;
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    protected int convertVerticalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        double verticalDialogUnitSize = (double)height * 0.125;
        return (int)Math.round((double)dlus * verticalDialogUnitSize);
    }

    public void setEnabled(boolean enabled) {
        IAction[] actions = this.actionProvider.getActions();
        if (actions != null && actions.length > 0) {
            int i = 0;
            while (i < actions.length) {
                actions[i].setEnabled(enabled);
                ++i;
            }
        }
    }

    class ButtonWrapper
    implements IPropertyChangeListener {
        private IAction buttonAction;
        private Button buttonControl;
        private boolean enabled = Boolean.FALSE;

        private ButtonWrapper() {
        }

        public ButtonWrapper(IAction buttonAction) {
            this.buttonAction = buttonAction;
            this.enabled = buttonAction.isEnabled();
            buttonAction.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public Control createControl(Composite parent, int style) {
            if (this.buttonControl == null) {
                this.buttonControl = new Button(parent, style);
                this.buttonControl.setText(this.buttonAction.getText() != null ? this.buttonAction.getText() : "%text%");
                this.buttonControl.setEnabled(this.enabled);
                this.buttonControl.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ButtonWrapper.this.buttonAction.run();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            return this.buttonControl;
        }

        public Control getControl() {
            return this.buttonControl;
        }

        public void dispose() {
            this.buttonControl.dispose();
            this.buttonControl = null;
            this.buttonAction = null;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            if (this.buttonControl != null) {
                this.buttonControl.setEnabled(enabled);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("enabled".equals(event.getProperty())) {
                this.enabled = (Boolean)event.getNewValue();
                if (this.buttonControl != null && !this.buttonControl.isDisposed()) {
                    this.buttonControl.setEnabled(this.enabled);
                }
            }
        }
    }
}

