/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Date;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.actions.ViolationSelectionAction;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReviewAction
extends ViolationSelectionAction {
    private static final Logger log;
    private IProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.views.actions.ReviewAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public ReviewAction(TableViewer tableViewer) {
        super(tableViewer);
        this.setImageDescriptor(PMDPlugin.getImageDescriptor("icons/btn_review.gif"));
        this.setText(this.getString("view.action.review"));
        this.setToolTipText(this.getString("view.tooltip.review"));
    }

    public void run() {
        final IMarker[] iMarkerArray = this.getSelectedViolations();
        final boolean bl = PMDPlugin.getDefault().loadPreferences().isReviewPmdStyleEnabled();
        if (iMarkerArray != null) {
            String string;
            boolean bl2 = true;
            if (iMarkerArray.length > 1 && !bl) {
                string = this.getString("message.confirm.title");
                String string2 = this.getString("message.confirm.review_multiple_markers");
                Shell shell = Display.getCurrent().getActiveShell();
                bl2 = MessageDialog.openConfirm((Shell)shell, (String)string, (String)string2);
            }
            if (bl2) {
                try {
                    string = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                    string.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            ReviewAction.this.setMonitor(iProgressMonitor);
                            iProgressMonitor.beginTask(ReviewAction.this.getString("monitor.review"), 5);
                            ReviewAction.this.insertReview(iMarkerArray[0], bl);
                            iProgressMonitor.done();
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    PMDPlugin.getDefault().logError(this.getString("message.error.invocationtarget_exception"), invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    PMDPlugin.getDefault().logError(this.getString("message.error.interrupted_exception"), interruptedException);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void insertReview(IMarker var1_1, boolean var2_2) {
        try {
            var3_3 = var1_1.getResource();
            if (!(var3_3 instanceof IFile)) return;
            var4_7 = (IFile)var3_3;
            if (var4_7.exists()) {
                var5_9 = this.readFile(var4_7);
                this.monitorWorked();
                var6_11 = this.getMarkerLineStart(var5_9, var1_1.getAttribute("lineNumber", 0));
                this.monitorWorked();
                var5_9 = var2_2 != false ? this.addPmdReviewComment(var5_9, var6_11, var1_1) : this.addPluginReviewComment(var5_9, var6_11, var1_1);
                this.monitorWorked();
                var4_7.setContents((InputStream)new ByteArrayInputStream(var5_9.getBytes()), false, true, this.getMonitor());
                this.monitorWorked();
                return;
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)this.getString("message.error.title"), (String)("The file " + var4_7.getName() + " doesn't exists ! Review aborted. Try to refresh the workspace and retry."));
            }
            return;
        }
        catch (JavaModelException var3_4) {
            var4_8 = var3_4.getJavaModelStatus();
            PMDPlugin.getDefault().logError((IStatus)var4_8);
            ReviewAction.log.warn((Object)("Ignoring Java Model Exception : " + var4_8.getMessage()));
            if (!ReviewAction.log.isDebugEnabled()) return;
            ReviewAction.log.debug((Object)("   code : " + var4_8.getCode()));
            ReviewAction.log.debug((Object)("   severity : " + var4_8.getSeverity()));
            var5_10 = var4_8.getElements();
            var6_12 = 0;
            ** while (var6_12 < var5_10.length)
        }
lbl-1000:
        // 1 sources

        {
            ReviewAction.log.debug((Object)("   element : " + var5_10[var6_12].getElementName() + " (" + var5_10[var6_12].getElementType() + ")"));
            ++var6_12;
            continue;
lbl30:
            // 1 sources

            return;
        }
        catch (CoreException var3_5) {
            PMDPlugin.getDefault().logError(this.getString("message.error.core_exception"), var3_5);
            return;
        }
        catch (IOException var3_6) {
            PMDPlugin.getDefault().logError(this.getString("message.error.io_exception"), var3_6);
        }
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    private void monitorWorked() {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(1);
        }
    }

    private int getMarkerLineStart(String string, int n) {
        int n2 = 0;
        int n3 = 1;
        n2 = 0;
        while (n2 < string.length()) {
            if (n3 == n) break;
            if (string.charAt(n2) == '\n') {
                ++n3;
            }
            ++n2;
        }
        if (string.charAt(n2) == '\r') {
            ++n2;
        }
        return n2;
    }

    private String addPluginReviewComment(String string, int n, IMarker iMarker) {
        String string2 = PMDPlugin.getDefault().loadPreferences().getReviewAdditionalComment();
        String string3 = MessageFormat.format(string2, System.getProperty("user.name", ""), new Date());
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        stringBuffer.append(this.computeIndent(string, n));
        stringBuffer.append("// @PMD:REVIEWED:");
        stringBuffer.append(iMarker.getAttribute("rulename", ""));
        stringBuffer.append(": ");
        stringBuffer.append(string3);
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private String addPmdReviewComment(String string, int n, IMarker iMarker) {
        String string2 = string;
        String string3 = PMDPlugin.getDefault().loadPreferences().getReviewAdditionalComment();
        String string4 = MessageFormat.format(string3, System.getProperty("user.name", ""), new Date());
        int n2 = string.substring(n).indexOf(13);
        if (n2 == -1 && (n2 = string.substring(n).indexOf(10)) == -1) {
            n2 = string.substring(n).length();
        }
        if (string.substring(n, n2 += n).indexOf("// NOPMD") == -1) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
            stringBuffer.append(' ');
            stringBuffer.append("// NOPMD");
            stringBuffer.append(' ');
            stringBuffer.append(string4);
            stringBuffer.append(string.substring(n2));
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private String computeIndent(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (Character.isWhitespace(string.charAt(n + n2))) {
            stringBuffer.append(string.charAt(n + n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String readFile(IFile iFile) throws IOException, CoreException {
        String string;
        InputStream inputStream = iFile.getContents(true);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            char[] cArray = new char[4096];
            StringBuffer stringBuffer = new StringBuffer(4096);
            while (inputStreamReader.ready()) {
                int n = inputStreamReader.read(cArray);
                if (n == -1) continue;
                stringBuffer.append(cArray, 0, n);
            }
            string = stringBuffer.toString();
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            inputStreamReader.close();
            throw throwable;
        }
        inputStreamReader.close();
        return string;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

