/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;

public class BooleanReturnNull
extends OpcodeStackDetector {
    BugAccumulator bugAccumulator;

    public BooleanReturnNull(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code code) {
        String s = this.getMethodSig();
        SignatureParser sp = new SignatureParser(s);
        boolean interesting = "Ljava/lang/Boolean;".equals(sp.getReturnTypeSignature());
        if (interesting) {
            super.visit(code);
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 176 && this.getPrevOpcode(1) == 1) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "NP_BOOLEAN_RETURN_NULL", 2).addClassAndMethod(this), this);
        }
    }
}

