/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.Arrays;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.hqleditor.HibernateResultCollector;

public class CompletionHelper {
    public static ICompletionProposal[] completeOnJavaTypes(IJavaProject javaProject, HibernateResultCollector.Settings settings, String packageName, String start, int offset) {
        if (javaProject != null) {
            IEvaluationContext context = javaProject.newEvaluationContext();
            if (packageName != null) {
                context.setPackageName(packageName);
            }
            HibernateResultCollector rc = new HibernateResultCollector(javaProject);
            rc.acceptContext(new CompletionContext());
            rc.setAccepts(settings);
            try {
                context.codeComplete(start, start.length(), (CompletionRequestor)rc);
            }
            catch (JavaModelException jme) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.CompletionHelper_could_not_complete_java_types, jme);
            }
            IJavaCompletionProposal[] results = rc.getJavaCompletionProposals();
            CompletionHelper.transpose(start, offset, results);
            return results;
        }
        return new ICompletionProposal[0];
    }

    public static void transpose(String start, int offset, IJavaCompletionProposal[] results) {
        int i = 0;
        while (i < results.length) {
            if (results[i] instanceof AbstractJavaCompletionProposal) {
                AbstractJavaCompletionProposal proposal = (AbstractJavaCompletionProposal)results[i];
                CompletionHelper.transpose(offset, proposal);
            } else {
                HibernateConsolePlugin.getDefault().log(HibernateConsoleMessages.CompletionHelper_error_unknown_completion_proposal_class);
            }
            ++i;
        }
        Arrays.sort(results, new CompletionProposalComparator());
    }

    private static void transpose(int offset, AbstractJavaCompletionProposal proposal) {
        int wanted = proposal.getReplacementOffset() + offset;
        proposal.getReplacementOffset();
        if (wanted < 0) {
            wanted = 0;
        }
        proposal.setReplacementOffset(wanted);
    }
}

