/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.DataflowGraph;
import net.sourceforge.pmd.eclipse.ui.views.DataflowGraphTable;
import net.sourceforge.pmd.eclipse.ui.views.DataflowGraphTableData;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DataflowGraphViewer
extends Composite {
    private SimpleNode method;
    private String resourceString;
    private DataflowGraphTable table;
    private DataflowGraph graph;
    protected static final int NODE_RADIUS = 12;
    protected static final int LINE_LENGTH = 25;
    protected static final int ROW_HEIGHT = 49;
    protected int[] colWidths;
    protected Color bgColor;
    protected Color lineColor;
    protected Color textColor;

    public DataflowGraphViewer(Composite composite, int n) {
        super(composite, n);
        this.setLayoutData(new GridData(1808));
        this.table = this.initTable(this, n);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.graph != null) {
            this.graph.addMouseListener(mouseListener);
        }
    }

    private DataflowGraphTable initTable(Composite composite, int n) {
        DataflowGraphTable dataflowGraphTable = new DataflowGraphTable(composite, n);
        this.colWidths = new int[]{50, 250, 70, 200, 200};
        String[] stringArray = new String[]{this.getString("view.dataflow.graph.column_line"), this.getString("view.dataflow.graph.column_graph"), this.getString("view.dataflow.graph.column_nextnodes"), this.getString("view.dataflow.graph.column_values"), this.getString("view.dataflow.graph.column_code")};
        dataflowGraphTable.setColumns(this.colWidths, stringArray, 1);
        this.bgColor = new Color(null, 255, 255, 255);
        this.lineColor = new Color(null, 192, 192, 192);
        this.textColor = new Color(null, 0, 0, 0);
        dataflowGraphTable.setColors(this.textColor, this.bgColor, this.lineColor);
        return dataflowGraphTable;
    }

    public void setData(SimpleNode simpleNode, String string) {
        if (this.method != null) {
            this.table.dispose();
            this.table = this.initTable(this, 0);
            this.layout();
        }
        this.method = simpleNode;
        this.resourceString = string;
        this.table.setRows(simpleNode.getDataFlowNode().getFlow().size(), 49);
        this.table.setTableData(this.createDataFields(simpleNode));
        this.graph = new DataflowGraph(this.table.getGraphArea(), simpleNode, 12, 25, 49);
    }

    public DataflowGraph getGraph() {
        return this.graph;
    }

    protected ArrayList createDataFields(SimpleNode simpleNode) {
        List list = simpleNode.getDataFlowNode().getFlow();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            Object object;
            ArrayList<DataflowGraphTableData> arrayList2 = new ArrayList<DataflowGraphTableData>();
            IDataFlowNode iDataFlowNode = (IDataFlowNode)list.get(n);
            arrayList2.add(new DataflowGraphTableData(String.valueOf(iDataFlowNode.getLine()), 0x1000000));
            arrayList2.add(null);
            String string = "";
            int n2 = 0;
            while (n2 < iDataFlowNode.getChildren().size()) {
                object = (IDataFlowNode)iDataFlowNode.getChildren().get(n2);
                if (n2 > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + String.valueOf(object.getIndex());
                ++n2;
            }
            arrayList2.add(new DataflowGraphTableData(string, 16448));
            List list2 = iDataFlowNode.getVariableAccess();
            if (list2 != null) {
                object = new StringBuffer();
                int n3 = 0;
                while (n3 < list2.size()) {
                    if (n3 > 0) {
                        ((StringBuffer)object).append(", ");
                    }
                    VariableAccess variableAccess = (VariableAccess)list2.get(n3);
                    switch (variableAccess.getAccessType()) {
                        case 0: {
                            ((StringBuffer)object).append("d(");
                            break;
                        }
                        case 1: {
                            ((StringBuffer)object).append("r(");
                            break;
                        }
                        case 2: {
                            ((StringBuffer)object).append("u(");
                            break;
                        }
                        default: {
                            ((StringBuffer)object).append("?(");
                        }
                    }
                    ((StringBuffer)object).append(String.valueOf(variableAccess.getVariableName()) + ")");
                    ++n3;
                }
                arrayList2.add(new DataflowGraphTableData(((StringBuffer)object).toString(), 16448));
            } else {
                arrayList2.add(null);
            }
            if (this.resourceString != null) {
                object = this.getCodeLine(this.resourceString, iDataFlowNode.getLine());
                arrayList2.add(new DataflowGraphTableData(((String)object).trim(), 16448));
            } else {
                arrayList2.add(null);
            }
            arrayList.add(arrayList2);
            ++n;
        }
        return arrayList;
    }

    protected String getCodeLine(String string, int n) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
            while (lineNumberReader.ready()) {
                String string2 = lineNumberReader.readLine();
                if (lineNumberReader.getLineNumber() != n) continue;
                return string2;
            }
        }
        catch (IOException iOException) {
            PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), iOException);
        }
        return null;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

