/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ViolationOverviewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String KEY_IMAGE_PACKAGE = "package";
    private static final String KEY_IMAGE_JAVAFILE = "javafile";
    private static final String KEY_IMAGE_ERR1 = "error1";
    private static final String KEY_IMAGE_ERR2 = "error2";
    private static final String KEY_IMAGE_ERR3 = "error3";
    private static final String KEY_IMAGE_ERR4 = "error4";
    private static final String KEY_IMAGE_ERR5 = "error5";
    private final ViolationOverview violationView;

    public ViolationOverviewLabelProvider(ViolationOverview violationOverview) {
        this.violationView = violationOverview;
    }

    public Image getColumnImage(Object object, int n) {
        Image image = null;
        if (n == 0) {
            if (object instanceof PackageRecord) {
                image = this.getImage(KEY_IMAGE_PACKAGE, "icons/obj_package.gif");
            } else if (object instanceof FileRecord || object instanceof FileToMarkerRecord) {
                image = this.getImage(KEY_IMAGE_JAVAFILE, "icons/obj_javacu.gif");
            } else if (object instanceof MarkerRecord) {
                MarkerRecord markerRecord = (MarkerRecord)object;
                int n2 = markerRecord.getPriority();
                image = this.getPriorityImage(n2);
            }
        }
        return image;
    }

    private Image getPriorityImage(int n) {
        Image image = null;
        switch (n) {
            case 1: {
                image = this.getImage(KEY_IMAGE_ERR1, "icons/lab_err1.gif");
                break;
            }
            case 2: {
                image = this.getImage(KEY_IMAGE_ERR2, "icons/lab_err2.gif");
                break;
            }
            case 3: {
                image = this.getImage(KEY_IMAGE_ERR3, "icons/lab_err3.gif");
                break;
            }
            case 4: {
                image = this.getImage(KEY_IMAGE_ERR4, "icons/lab_err4.gif");
                break;
            }
            case 5: {
                image = this.getImage(KEY_IMAGE_ERR5, "icons/lab_err5.gif");
            }
        }
        return image;
    }

    public String getColumnText(Object object, int n) {
        String string = "";
        if (object instanceof AbstractPMDRecord) {
            AbstractPMDRecord abstractPMDRecord = (AbstractPMDRecord)object;
            switch (n) {
                case 0: {
                    string = this.getElementName(object);
                    break;
                }
                case 1: {
                    string = this.getNumberOfViolations(abstractPMDRecord);
                    break;
                }
                case 2: {
                    string = this.getViolationsPerLOC(abstractPMDRecord);
                    break;
                }
                case 3: {
                    string = this.getViolationsPerMethod(abstractPMDRecord);
                    break;
                }
                case 4: {
                    string = this.getProjectName(object);
                }
            }
        }
        return string;
    }

    private String getNumberOfViolations(AbstractPMDRecord abstractPMDRecord) {
        String string;
        int n;
        int n2 = this.violationView.getNumberOfFilteredViolations(abstractPMDRecord);
        String string2 = String.valueOf(n2);
        if (abstractPMDRecord instanceof MarkerRecord && this.violationView.getShowType() != 3) {
            String string3 = ((MarkerRecord)abstractPMDRecord).getName();
            int n3 = this.getMaxViolations(string3);
            if (n2 == n3) {
                string2 = "(max) " + string2;
            }
        } else if (abstractPMDRecord instanceof FileToMarkerRecord && n2 == (n = this.getMaxViolations(string = ((FileToMarkerRecord)abstractPMDRecord).getParent().getName()))) {
            string2 = "(max) " + string2;
        }
        return string2;
    }

    private int getMaxViolations(String string) {
        int n = PMDPlugin.getDefault().loadPreferences().getMaxViolationsPerFilePerRule();
        Rule rule = PMDPlugin.getDefault().getPreferencesManager().getRuleSet().getRuleByName(string);
        if (rule != null && rule.hasProperty("maxviolations")) {
            n = rule.getIntProperty("maxviolations");
        }
        return n;
    }

    private String getElementName(Object object) {
        String string = "";
        if (object instanceof PackageRecord) {
            string = ((PackageRecord)object).getName();
        } else if (object instanceof FileRecord) {
            string = ((FileRecord)object).getName();
        } else if (object instanceof MarkerRecord) {
            string = ((MarkerRecord)object).getName();
        } else if (object instanceof FileToMarkerRecord) {
            string = ((FileToMarkerRecord)object).getParent().getParent().getName();
        }
        return string;
    }

    private String getViolationsPerLOC(AbstractPMDRecord abstractPMDRecord) {
        String string = "";
        int n = this.violationView.getNumberOfFilteredViolations(abstractPMDRecord);
        int n2 = this.violationView.getLOC(abstractPMDRecord);
        if (n2 == 0) {
            string = "N/A";
        } else {
            double d = (double)(n * 1000) / (double)n2;
            if (d < 0.1) {
                string = "< 0.1 / 1000";
            } else {
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
                decimalFormat.applyPattern("##0.0");
                string = String.valueOf(decimalFormat.format(d)) + " / 1000";
            }
        }
        return string;
    }

    private String getViolationsPerMethod(AbstractPMDRecord abstractPMDRecord) {
        String string = "";
        int n = this.violationView.getNumberOfFilteredViolations(abstractPMDRecord);
        int n2 = this.violationView.getNumberOfMethods(abstractPMDRecord);
        if (n2 == 0) {
            string = "N/A";
        } else {
            double d = (double)n / (double)n2;
            if (d < 0.01 || n2 == 0) {
                string = "< 0.01";
            } else {
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
                decimalFormat.applyPattern("##0.00");
                string = decimalFormat.format(d);
            }
        }
        return string;
    }

    private String getProjectName(Object object) {
        String string = "";
        AbstractPMDRecord abstractPMDRecord = null;
        if (object instanceof PackageRecord) {
            abstractPMDRecord = ((PackageRecord)object).getParent();
        } else if (object instanceof FileRecord) {
            abstractPMDRecord = ((FileRecord)object).getParent().getParent();
        } else if (object instanceof MarkerRecord) {
            abstractPMDRecord = ((MarkerRecord)object).getParent().getParent().getParent();
        } else if (object instanceof FileToMarkerRecord) {
            abstractPMDRecord = ((FileToMarkerRecord)object).getParent().getParent().getParent().getParent();
        }
        if (abstractPMDRecord != null) {
            string = abstractPMDRecord.getName();
        }
        return string;
    }

    private Image getImage(String string, String string2) {
        return PMDPlugin.getDefault().getImage(string, string2);
    }
}

