/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validation;

import java.util.Set;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.struts.model.handlers.JumpByForwardPathHandler;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.TilesHelper;
import org.jboss.tools.struts.validation.StrutsValidatorMessages;
import org.jboss.tools.struts.validation.ValidateTypeUtil;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class ActionForwardCheck
extends Check {
    XModelObject object;
    protected XModel model;
    protected XModelObject forward;
    protected XModelObject config;
    protected String path;
    protected String module;
    protected Set modules;
    protected String pathModule = null;
    protected static StrutsProcessStructureHelper h = new StrutsProcessStructureHelper();
    protected String pathEmpty = StrutsValidatorMessages.ACTION_FORWARD_PATH_EMPTY;
    protected String pathExists = StrutsValidatorMessages.ACTION_FORWARD_PATH_EXISTS;
    protected String classNameExists = StrutsValidatorMessages.ACTION_FORWARD_CLASSNAME_EXISTS;
    protected String contextRelativeCross = StrutsValidatorMessages.ACTION_FORWARD_CONTEXT_RELATIVE_CROSS;
    protected String contextRelativeMono = StrutsValidatorMessages.ACTION_FORWARD_CONTEXT_RELATIVE_MONO;

    public ActionForwardCheck(ValidationErrorManager manager, String preference) {
        super(manager, preference, "");
    }

    protected boolean isRelevant(XModelObject object) {
        return object.getParent() != null && object.getParent().getModelEntity().getName().startsWith("StrutsAction");
    }

    public void check(XModelObject object) {
        this.object = object;
        if (!this.isRelevant(object)) {
            return;
        }
        this.forward = object;
        this.model = this.forward.getModel();
        this.path = JumpByForwardPathHandler.getResourcePath(this.forward.getAttributeValue("path"));
        if (!this.checkPath()) {
            return;
        }
        this.checkClasses();
    }

    protected void checkClasses() {
        this.checkClass("className", this.classNameExists);
    }

    protected boolean isAllowedEmptyPath() {
        return false;
    }

    protected boolean checkPath() {
        boolean cR;
        if (this.path.length() == 0) {
            if (this.isAllowedEmptyPath()) {
                return true;
            }
            this.fire(this.pathEmpty, "path", null);
            return false;
        }
        this.config = StrutsProcessStructureHelper.instance.getParentFile(this.forward);
        WebModulesHelper wh = WebModulesHelper.getInstance(this.model);
        if (TilesHelper.findTile(this.config, this.path) != null) {
            return true;
        }
        this.module = StrutsProcessStructureHelper.instance.getProcessModule(this.forward);
        this.modules = wh.getModules();
        this.pathModule = wh.getModuleForPath(this.path, this.module);
        if (this.pathModule == null) {
            this.pathModule = "";
        }
        if (StrutsProcessHelper.isHttp(this.path)) {
            return true;
        }
        UrlPattern up = wh.getUrlPattern(this.module);
        boolean isFolder = this.path.endsWith("/") && this.path.startsWith("/");
        boolean isAction = !isFolder && up.isActionUrl(this.path);
        boolean isPage = this.path.endsWith(".jsp") || this.path.indexOf(".htm") > 0 || this.path.endsWith(".css");
        String s = this.forward.getAttributeValue("contextRelative");
        boolean bl = cR = "true".equals(s) || "yes".equals(s);
        if (isFolder || isAction || isPage) {
            if (this.forward.getModelEntity().getAttribute("contextRelative") != null) {
                if (!cR && this.pathModule.length() > 0 && this.path.startsWith(String.valueOf(this.pathModule) + "/")) {
                    this.fire(this.contextRelativeCross, "contextRelative", null);
                    return false;
                }
                if (cR && this.pathModule.length() > 0 && !this.path.startsWith(String.valueOf(this.pathModule) + "/")) {
                    this.fire(this.contextRelativeMono, "contextRelative", null);
                    return false;
                }
            } else if (!this.pathModule.equals(this.module) || this.pathModule.length() > 0 && this.path.startsWith(String.valueOf(this.pathModule) + "/")) {
                this.fire(this.contextRelativeMono, "path", null);
                return false;
            }
        }
        XModelObject target = null;
        String kind = "tile";
        if (isFolder) {
            kind = "resource folder";
            target = this.model.getByPath(this.path.substring(0, this.path.length() - 1));
        } else if (isAction) {
            kind = "action";
            this.path = up.getActionPath(this.path);
            if (!cR) {
                target = this.config.getChildByPath("action-mappings/" + this.path.replace('/', '#'));
                if (target == null) {
                    XModelObject[] cgs = wh.getConfigsForModule(this.model, this.pathModule);
                    int i = 0;
                    while (i < cgs.length && target == null) {
                        if (cgs[i] != this.config) {
                            target = cgs[i].getChildByPath("action-mappings/" + this.path.replace('/', '#'));
                        }
                        ++i;
                    }
                }
            } else {
                XModelObject[] cgs = wh.getConfigsForModule(this.model, this.pathModule);
                if (cgs.length > 0 && this.pathModule.length() > 0 && this.path.startsWith(this.pathModule)) {
                    this.path = this.path.substring(this.pathModule.length());
                }
                int i = 0;
                while (i < cgs.length && target == null) {
                    target = cgs[i].getChildByPath("action-mappings/" + this.path.replace('/', '#'));
                    ++i;
                }
            }
        } else {
            XModelObject fs;
            String string = kind = isPage ? "page" : "tile or page";
            if (this.path.endsWith(".css")) {
                kind = "resource";
            }
            if ((fs = wh.getRootFileSystemForModule(this.model, this.pathModule)) != null) {
                if (this.pathModule.length() > 0 && this.path.startsWith(this.pathModule)) {
                    this.path = this.path.substring(this.pathModule.length());
                }
                if (this.path.startsWith("/")) {
                    this.path = this.path.substring(1);
                }
                target = fs.getChildByPath(this.path);
            }
        }
        if (target != null) {
            return true;
        }
        this.fire(this.pathExists, "path", kind);
        return false;
    }

    protected boolean checkClass(String attr, String id) {
        ValidateTypeUtil tv = new ValidateTypeUtil();
        int tvr = tv.checkClass(this.object, attr, "org.apache.struts.action.ActionForward");
        if (tvr == ValidateTypeUtil.NOT_FOUND) {
            this.fire(id, attr, null);
            return false;
        }
        return true;
    }

    protected void fire(String id, String attr, String info) {
        String[] stringArray;
        this.attr = attr;
        String oTitle = DefaultCreateHandler.title((XModelObject)this.object, (boolean)true);
        String pTitle = DefaultCreateHandler.title((XModelObject)this.object.getParent(), (boolean)true);
        if (info == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = oTitle;
            stringArray = stringArray2;
            stringArray2[1] = pTitle;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = oTitle;
            stringArray3[1] = pTitle;
            stringArray = stringArray3;
            stringArray3[2] = info;
        }
        String[] os = stringArray;
        this.fireMessage(this.object, id, os);
    }
}

