/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeElementCreator
extends VpeAbstractCreator {
    private boolean caseSensitive;
    private VpeExpression expression;

    VpeElementCreator(Element element, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(element, dependencyMap);
    }

    private void build(Element element, VpeDependencyMap dependencyMap) {
        Attr nameAttr = element.getAttributeNode("name");
        if (nameAttr != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(nameAttr.getNodeValue(), this.caseSensitive);
                this.expression = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        if (this.expression != null) {
            visualNodeMap.put(this, visualElement);
            VpeValue vpeValue = this.expression.exec(pageContext, sourceNode);
            if (vpeValue != null && vpeValue.stringValue().length() > 0) {
                nsIDOMElement newVisualElement = visualDocument.createElement(vpeValue.stringValue());
                return new VpeCreatorInfo((nsIDOMNode)newVisualElement);
            }
        }
        return null;
    }

    @Override
    public boolean isRecreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        return true;
    }
}

