/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.vpe.editor.template.textformating.FormatAttributeData;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.ToolItemFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleAttribute;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleProperty;
import org.w3c.dom.Attr;

public class UnderlineFormatController
extends ToolItemFormatController {
    public static String TYPE = "UnderlineFormat";
    private static String STYLE_PROPERTY_NAME = "TEXT-DECORATION";
    private static String STYLE_PROPERTY_UNDERLINE_VALUE = "underline";
    private static String STYLE_PROPERTY_NORMAL_VALUE = "none";

    public UnderlineFormatController(FormatControllerManager manager, ToolItem toolItem) {
        super(manager, toolItem);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void setStyle(Attr styleAttribute, FormatAttributeData templateData) {
        Object value;
        StyleAttribute style = new StyleAttribute(styleAttribute);
        StyleProperty property = style.getProperty(STYLE_PROPERTY_NAME);
        if (templateData.getParentFormatData().isSetDefault()) {
            if (property == null) {
                style.addStyleProperty(STYLE_PROPERTY_NAME, STYLE_PROPERTY_NORMAL_VALUE);
            } else {
                value = property.getSinglePropertyValue(STYLE_PROPERTY_NORMAL_VALUE);
                if (value != null) {
                    style.removeStyleProperty(STYLE_PROPERTY_NAME);
                } else {
                    style.removeStyleProperty(STYLE_PROPERTY_NAME);
                    style.addStyleProperty(STYLE_PROPERTY_NAME, STYLE_PROPERTY_NORMAL_VALUE);
                }
            }
        } else if (property == null) {
            style.addStyleProperty(STYLE_PROPERTY_NAME, STYLE_PROPERTY_UNDERLINE_VALUE);
        } else {
            value = property.getSinglePropertyValue(STYLE_PROPERTY_UNDERLINE_VALUE);
            if (value != null) {
                style.removeStyleProperty(STYLE_PROPERTY_NAME, STYLE_PROPERTY_UNDERLINE_VALUE);
            } else {
                style.addStyleProperty(STYLE_PROPERTY_NAME, STYLE_PROPERTY_UNDERLINE_VALUE);
            }
        }
        value = style.toString().trim();
        if (((String)value).length() == 0) {
            styleAttribute.getOwnerElement().removeAttributeNode(styleAttribute);
        } else {
            styleAttribute.setValue((String)value);
        }
    }

    @Override
    protected boolean isStyleSet(Attr attribute, FormatAttributeData templateData) {
        boolean isSetDefault = templateData.getParentFormatData().isSetDefault();
        String value = isSetDefault ? STYLE_PROPERTY_NORMAL_VALUE : STYLE_PROPERTY_UNDERLINE_VALUE;
        boolean isStyleSet = UnderlineFormatController.isStyleSet(STYLE_PROPERTY_NAME, value, attribute);
        if (isSetDefault) {
            return !isStyleSet;
        }
        return isStyleSet;
    }
}

