/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.ProjectModelException;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.resources.java.JavaResourceVisitor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.util.Packages;

@Dependent
@Alias(value="forge.maven.JavaSourceFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class MavenJavaSourceFacet
extends BaseFacet
implements JavaSourceFacet,
Facet {
    public List<DirectoryResource> getSourceFolders() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getSourceFolder());
        result.add(this.getTestSourceFolder());
        return result;
    }

    public String calculateName(JavaResource resource) {
        String fullPath = Packages.fromFileSyntax((String)resource.getFullyQualifiedName());
        String pkg = this.calculatePackage(resource);
        String name = fullPath.substring(fullPath.lastIndexOf(pkg) + pkg.length() + 1);
        name = name.substring(0, name.lastIndexOf(".java"));
        return name;
    }

    public String calculatePackage(JavaResource resource) {
        List<DirectoryResource> folders = this.getSourceFolders();
        String pkg = null;
        for (DirectoryResource folder : folders) {
            String sourcePrefix = folder.getFullyQualifiedName();
            pkg = resource.getParent().getFullyQualifiedName();
            if (!pkg.startsWith(sourcePrefix)) continue;
            pkg = pkg.substring(sourcePrefix.length() + 1);
            break;
        }
        pkg = Packages.fromFileSyntax(pkg);
        return pkg;
    }

    public String getBasePackage() {
        return ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).getMavenProject().getGroupId();
    }

    public DirectoryResource getBasePackageResource() {
        return this.getSourceFolder().getChildDirectory(Packages.toFileSyntax((String)this.getBasePackage()));
    }

    public DirectoryResource getSourceFolder() {
        DirectoryResource projectRoot = this.project.getProjectRoot();
        return projectRoot.getChildDirectory("src" + File.separator + "main" + File.separator + "java");
    }

    public DirectoryResource getTestSourceFolder() {
        DirectoryResource projectRoot = this.project.getProjectRoot();
        return projectRoot.getChildDirectory("src" + File.separator + "test" + File.separator + "java");
    }

    public boolean isInstalled() {
        MavenCoreFacet mavenFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        return this.getSourceFolder().exists() && mavenFacet != null && mavenFacet.isInstalled();
    }

    public boolean install() {
        if (!this.isInstalled()) {
            for (DirectoryResource folder : this.getSourceFolders()) {
                folder.mkdirs();
            }
            MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = maven.getPOM();
            Build build = pom.getBuild();
            if (build == null) {
                build = new Build();
            }
            List plugins = build.getPlugins();
            Plugin javaSourcePlugin = null;
            for (Plugin plugin : plugins) {
                if (!"org.apache.maven.plugins".equals(plugin.getGroupId()) || !"maven-compiler-plugin".equals(plugin.getArtifactId())) continue;
                javaSourcePlugin = plugin;
            }
            if (javaSourcePlugin == null) {
                javaSourcePlugin = new Plugin();
                javaSourcePlugin.setGroupId("org.apache.maven.plugins");
                javaSourcePlugin.setArtifactId("maven-compiler-plugin");
                javaSourcePlugin.setVersion("2.3.2");
                try {
                    Xpp3Dom dom = Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream("<configuration><source>1.6</source><target>1.6</target><encoding>UTF-8</encoding></configuration>".getBytes()), (String)"UTF-8");
                    javaSourcePlugin.setConfiguration((Object)dom);
                }
                catch (Exception e) {
                    throw new ProjectModelException((Throwable)e);
                }
            }
            build.addPlugin(javaSourcePlugin);
            pom.setBuild(build);
            maven.setPOM(pom);
        }
        return true;
    }

    public JavaResource getJavaResource(JavaSource<?> javaClass) throws FileNotFoundException {
        return this.getJavaResource(javaClass.getPackage() + "." + javaClass.getName());
    }

    public JavaResource getEnumTypeResource(JavaEnum javaEnum) throws FileNotFoundException {
        return this.getEnumTypeResource(javaEnum.getPackage() + "." + javaEnum.getName());
    }

    public JavaResource getTestJavaResource(JavaSource<?> javaClass) throws FileNotFoundException {
        return this.getTestJavaResource(javaClass.getPackage() + "." + javaClass.getName());
    }

    public JavaResource getJavaResource(String relativePath) throws FileNotFoundException {
        return this.getJavaResource(this.getSourceFolder(), relativePath);
    }

    public JavaResource getEnumTypeResource(String relativePath) throws FileNotFoundException {
        return this.getEnumTypeResource(this.getSourceFolder(), relativePath);
    }

    public JavaResource getTestJavaResource(String relativePath) throws FileNotFoundException {
        return this.getJavaResource(this.getTestSourceFolder(), relativePath);
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = Packages.toFileSyntax((String)path) + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    private JavaResource getEnumTypeResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = Packages.toFileSyntax((String)path) + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    public JavaResource saveJavaSource(JavaSource<?> source) throws FileNotFoundException {
        return this.getJavaResource(source.getQualifiedName()).setContents(source);
    }

    public JavaResource saveEnumTypeSource(JavaEnum source) throws FileNotFoundException {
        return this.getEnumTypeResource(source.getQualifiedName()).setContents((JavaSource)source);
    }

    public JavaResource saveTestJavaSource(JavaSource<?> source) throws FileNotFoundException {
        return this.getTestJavaResource(source.getQualifiedName()).setContents(source);
    }

    public void visitJavaSources(JavaResourceVisitor visitor) {
        this.visitSources((Resource<?>)this.getSourceFolder(), visitor);
    }

    public void visitJavaTestSources(JavaResourceVisitor visitor) {
        this.visitSources((Resource<?>)this.getTestSourceFolder(), visitor);
    }

    private void visitSources(Resource<?> searchFolder, final JavaResourceVisitor visitor) {
        if (searchFolder instanceof DirectoryResource) {
            searchFolder.listResources(new ResourceFilter(){

                public boolean accept(Resource<?> resource) {
                    if (resource instanceof DirectoryResource) {
                        MavenJavaSourceFacet.this.visitSources(resource, visitor);
                    }
                    if (resource instanceof JavaResource) {
                        visitor.visit((JavaResource)resource);
                    }
                    return false;
                }
            });
        }
    }
}

