/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.util;

import java.util.Collection;
import java.util.Iterator;

public class Strings {
    public static String capitalize(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String unquote(String value) {
        String result = null;
        if (value != null) {
            result = value.replaceAll("\"(.*)\"", "$1");
        }
        return result;
    }

    public static String enquote(String value) {
        String result = null;
        if (value != null) {
            result = "\"" + value + "\"";
        }
        return result;
    }

    public static String join(Collection<?> collection, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isTrue(String value) {
        return value == null ? false : "true".equalsIgnoreCase(value.trim());
    }

    public static boolean areEqual(String left, String right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public static boolean areEqualTrimmed(String left, String right) {
        if (left != null && right != null) {
            return left.trim().equals(right.trim());
        }
        return Strings.areEqual(left, right);
    }

    public static String stripQuotes(String value) {
        if (value != null && (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) && value.length() > 2) {
            value = value.substring(1, value.length() - 2);
        }
        return value;
    }

    public static String uncapitalize(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }
}

