/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.QueryInputModel;
import org.hibernate.eclipse.console.ComboContribution;
import org.hibernate.eclipse.console.ConfigurationCombo;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.console.QueryEditorInput;
import org.hibernate.eclipse.console.actions.ClearAction;
import org.hibernate.eclipse.console.actions.ExecuteQueryAction;
import org.hibernate.eclipse.console.actions.StickResTabAction;

public abstract class AbstractQueryEditor
extends TextEditor
implements QueryEditor,
IShowEditorInput {
    private ToolBarManager tbm;
    private ExecuteQueryAction execAction = null;
    private ClearAction clearAction = null;
    private StickResTabAction stickResTabAction = null;
    private final QueryInputModel queryInputModel = new QueryInputModel();
    private String defPartName;
    private Image defTitleImage;
    private Image connectedTitleImage;
    private String consoleConfigurationName;
    protected boolean pinToOneResTab = false;

    @Override
    public final boolean askUserForConfiguration(String name) {
        String out = NLS.bind((String)HibernateConsoleMessages.AbstractQueryEditor_do_you_want_open_session_factory, (Object)name);
        return MessageDialog.openQuestion((Shell)HibernateConsolePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)HibernateConsoleMessages.AbstractQueryEditor_open_session_factory, (String)out);
    }

    @Override
    public final ConsoleConfiguration getConsoleConfiguration() {
        return KnownConfigurations.getInstance().find(this.getConsoleConfigurationName());
    }

    @Override
    public final String getConsoleConfigurationName() {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            QueryEditorInput hei = (QueryEditorInput)this.getEditorInput();
            return hei.getConsoleConfigurationName();
        }
        return this.consoleConfigurationName;
    }

    @Override
    public final void setConsoleConfigurationName(String name) {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            QueryEditorInput hei = (QueryEditorInput)this.getEditorInput();
            hei.setConsoleConfigurationName(name);
            hei.setQuery(this.getEditorText());
            hei.resetName();
        }
        this.consoleConfigurationName = name;
        this.showEditorInput(this.getEditorInput());
    }

    protected void updateExecButton() {
        this.execAction.setEnabled(this.getQueryString().trim().length() > 0 && this.getConsoleConfigurationName().length() != 0);
    }

    public void showEditorInput(IEditorInput editorInput) {
        try {
            this.doSetInput(editorInput);
            this.updateExecButton();
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.AbstractQueryEditor_could_not_show_query_editor_input, e);
        }
    }

    public final void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p;
        QueryEditorInput hei = null;
        if (this.getEditorInput() instanceof QueryEditorInput) {
            hei = (QueryEditorInput)this.getEditorInput();
            hei.setQuery(this.getEditorText());
        }
        if ((p = this.getDocumentProvider()) != null && p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                String title = HibernateConsoleMessages.AbstractQueryEditor_cannot_save;
                String msg = HibernateConsoleMessages.AbstractQueryEditor_the_file_has_been_deleted_or_is_not_accessible;
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        } else {
            this.performSave(false, progressMonitor);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
    }

    @Override
    public final String getEditorText() {
        IEditorInput editorInput = this.getEditorInput();
        IDocumentProvider docProvider = this.getDocumentProvider();
        IDocument doc = docProvider.getDocument((Object)editorInput);
        return doc.get();
    }

    @Override
    public String getQueryString() {
        return this.getEditorText();
    }

    public final void dispose() {
        super.dispose();
        if (this.tbm != null) {
            this.tbm.dispose();
        }
    }

    protected final void createToolbar(Composite parent) {
        ToolBar bar = new ToolBar(parent, 256);
        bar.setLayoutData((Object)new GridData(768));
        this.tbm = new ToolBarManager(bar);
        this.execAction = new ExecuteQueryAction(this);
        this.clearAction = new ClearAction((ITextEditor)this);
        this.stickResTabAction = new StickResTabAction((ITextEditor)this);
        ActionContributionItem item = new ActionContributionItem((IAction)this.execAction);
        this.tbm.add((IContributionItem)item);
        item = new ActionContributionItem((IAction)this.clearAction);
        this.tbm.add((IContributionItem)item);
        ComboContribution cc = new ConfigurationCombo("hql-target", this);
        this.tbm.add((IContributionItem)cc);
        this.tbm.add((IContributionItem)new Separator());
        cc = new ComboContribution("maxResults"){
            SelectionAdapter selectionAdapter;
            {
                this.selectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Integer maxResults = null;
                        try {
                            maxResults = new Integer(this.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            maxResults = null;
                        }
                        AbstractQueryEditor.this.queryInputModel.setMaxResults(maxResults);
                    }
                };
            }

            @Override
            protected Control createControl(Composite parent) {
                Control control = super.createControl(parent);
                this.comboControl.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Integer maxResults = null;
                        try {
                            maxResults = new Integer(this.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            maxResults = null;
                        }
                        AbstractQueryEditor.this.queryInputModel.setMaxResults(maxResults);
                    }
                });
                return control;
            }

            @Override
            protected int getComboWidth() {
                return 75;
            }

            @Override
            protected String getLabelText() {
                return HibernateConsoleMessages.AbstractQueryEditor_max_results;
            }

            @Override
            protected boolean isReadOnly() {
                return false;
            }

            @Override
            protected SelectionListener getSelectionAdapter() {
                return this.selectionAdapter;
            }

            @Override
            void populateComboBox() {
                this.comboControl.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String[] items = new String[]{"", "10", "20", "30", "50"};
                        comboControl.setItems(items);
                    }
                });
            }
        };
        this.tbm.add((IContributionItem)cc);
        this.tbm.add((IContributionItem)new Separator());
        item = new ActionContributionItem((IAction)this.stickResTabAction);
        this.tbm.add((IContributionItem)item);
        this.tbm.update(true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.hibernate.eclipse.console.hql"});
    }

    @Override
    public QueryInputModel getQueryInputModel() {
        return this.queryInputModel;
    }

    public void showConnected(IEditorPart editor) {
        this.defPartName = this.getPartName();
        this.defTitleImage = this.getTitleImage();
        this.setPartName(String.valueOf(this.defPartName) + "->" + editor.getTitle());
        if (this.connectedTitleImage == null) {
            this.connectedTitleImage = HibernateConsolePlugin.getImageDescriptor(this.getConnectedImageFilePath()).createImage();
        }
        this.setTitleImage(this.connectedTitleImage);
    }

    public void showDisconnected() {
        this.setPartName(this.defPartName);
        if (this.defTitleImage != null && !this.defTitleImage.isDisposed()) {
            this.setTitleImage(this.defTitleImage);
        } else {
            this.setTitleImage(null);
        }
        this.connectedTitleImage.dispose();
    }

    protected abstract String getConnectedImageFilePath();

    protected abstract String getSaveAsFileExtension();

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block26: {
            Object newInput;
            SaveAsDialog dialog;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            IDocumentProvider provider = this.getDocumentProvider();
            if (input instanceof IURIEditorInput && !(input instanceof IFileEditorInput)) {
                IFileStore fileStore;
                MessageDialog overwriteDialog;
                String path;
                dialog = new FileDialog(shell, 8192);
                IPath oldPath = URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
                if (oldPath != null) {
                    dialog.setFileName(oldPath.lastSegment());
                    dialog.setFilterPath(oldPath.toOSString());
                }
                if ((path = dialog.open()) == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                File localFile = new File(path);
                if (localFile.exists() && (overwriteDialog = new MessageDialog(shell, HibernateConsoleMessages.AbstractQueryEditor_save_as, null, NLSUtility.format((String)HibernateConsoleMessages.AbstractQueryEditor_already_exists_do_you_want_to_replace_it, (Object)path), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0 && progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                    return;
                }
                try {
                    fileStore = EFS.getStore((URI)localFile.toURI());
                }
                catch (CoreException ex) {
                    EditorsPlugin.log((IStatus)ex.getStatus());
                    String title = HibernateConsoleMessages.AbstractQueryEditor_problems_during_save_as;
                    String msg = NLSUtility.format((String)HibernateConsoleMessages.AbstractQueryEditor_save_could_not_be_completed, (Object)ex.getMessage());
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    return;
                }
                IFile file = this.getWorkspaceFile(fileStore);
                newInput = file != null ? new FileEditorInput(file) : new FileStoreEditorInput(fileStore);
            } else {
                IFile original;
                dialog = new SaveAsDialog(shell);
                IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
                if (original != null) {
                    dialog.setOriginalFile(original);
                } else {
                    dialog.setOriginalName(this.getSaveAsFileExtension());
                }
                dialog.create();
                if (provider.isDeleted((Object)input) && original != null) {
                    String message = NLSUtility.format((String)HibernateConsoleMessages.AbstractQueryEditor_the_original_file_has_been_deleted_or_is_not_accessible, (Object)original.getName());
                    dialog.setErrorMessage(null);
                    dialog.setMessage(message, 2);
                }
                if (dialog.open() == 1) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IPath filePath = dialog.getResult();
                if (filePath == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile file = workspace.getRoot().getFile(filePath);
                newInput = new FileEditorInput(file);
            }
            if (provider == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange(newInput);
                    provider.saveDocument(progressMonitor, newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = HibernateConsoleMessages.AbstractQueryEditor_problems_during_save_as;
                        String msg = NLSUtility.format((String)HibernateConsoleMessages.AbstractQueryEditor_save_could_not_be_completed, (Object)x.getMessage());
                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    }
                    provider.changed(newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                provider.changed(newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed(newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocation(URIUtil.toPath((URI)fileStore.toURI()));
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }

    public boolean initTextAndToolTip(String text) {
        if (this.execAction != null) {
            this.execAction.initTextAndToolTip(text);
            return true;
        }
        return false;
    }

    public boolean getPinToOneResTab() {
        return this.pinToOneResTab;
    }

    public void setPinToOneResTab(boolean pinToOneResTab) {
        this.pinToOneResTab = pinToOneResTab;
    }
}

