/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.jpa.core.JpaDataSource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.hibernate.console.ext.HibernateExtensionManager;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizard;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizardPage;
import org.hibernate.eclipse.launch.ConnectionProfileCtrl;
import org.hibernate.eclipse.launch.ConsoleConfigurationTab;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.util.xpl.StringHelper;

public class ConsoleConfigurationMainTab
extends ConsoleConfigurationTab {
    protected boolean configurationFileWillBeCreated = false;
    private Button coreMode;
    private Combo hibernateVersion;
    private Button jpaMode;
    private Button annotationsMode;
    private Button confbutton;
    private Button persistenceUnitNameButton;
    private Text propertyFileText;
    private Text configurationFileText;
    private Text projectNameText;
    private Text persistenceUnitNameText;
    private ConnectionProfileCtrl connectionProfileCtrl;

    public String getName() {
        return HibernateConsoleMessages.ConsoleConfigurationMainTab_main;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        this.createConfigurationMode(comp);
        this.createProjectEditor(comp);
        this.createDBConnectConfig(comp);
        this.createPropertyFileEditor(comp);
        this.createConfigurationFileEditor(comp);
        this.createPersistenceUnitEditor(comp);
    }

    private void createDBConnectConfig(Composite container) {
        Group group = SWTFactory.createGroup((Composite)container, (String)HibernateConsoleMessages.ConsoleConfigurationMainTab_DatabaseConnection, (int)3, (int)2, (int)768);
        this.connectionProfileCtrl = new ConnectionProfileCtrl((Composite)group, 1, "");
        this.connectionProfileCtrl.addModifyListener(this.getChangeListener());
    }

    private void createConfigurationMode(Composite container) {
        Group group = this.createGroup(container, HibernateConsoleMessages.ConsoleConfigurationMainTab_type);
        group.setLayout((Layout)new GridLayout(4, false));
        this.coreMode = new Button((Composite)group, 16);
        this.coreMode.setText(HibernateConsoleMessages.ConsoleConfigurationMainTab_core);
        this.coreMode.addSelectionListener((SelectionListener)this.getChangeListener());
        this.coreMode.setSelection(true);
        this.annotationsMode = new Button((Composite)group, 16);
        this.annotationsMode.setText(HibernateConsoleMessages.ConsoleConfigurationMainTab_annotations);
        this.annotationsMode.addSelectionListener((SelectionListener)this.getChangeListener());
        this.jpaMode = new Button((Composite)group, 16);
        this.jpaMode.setText(HibernateConsoleMessages.ConsoleConfigurationMainTab_jpa);
        this.jpaMode.addSelectionListener((SelectionListener)this.getChangeListener());
        new Label((Composite)group, 0);
        Composite comp2 = new Composite((Composite)group, 0);
        comp2.setLayout((Layout)new GridLayout(2, false));
        comp2.setLayoutData((Object)new GridData(1, -1, false, false, 2, 1));
        Label hLabel = new Label(comp2, 0);
        hLabel.setText(HibernateConsoleMessages.ConsoleConfigurationMainTab_0);
        this.hibernateVersion = new Combo(comp2, 8);
        this.hibernateVersion.setItems(HibernateExtensionManager.getHibernateExtensionDefinitionsAsMap().keySet().toArray(new String[0]));
        this.hibernateVersion.select(0);
        this.hibernateVersion.setLayoutData((Object)new GridData(53, -1));
        this.hibernateVersion.addModifyListener((ModifyListener)this.getChangeListener());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
    }

    protected void createProjectEditor(Composite parent) {
        Group group = this.createGroup(parent, HibernateConsoleMessages.ConsoleConfigurationMainTab_project);
        this.projectNameText = this.createBrowseEditor(parent, group);
        this.createBrowseButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationMainTab.this.handleProjectBrowse();
            }
        });
    }

    private void createPropertyFileEditor(Composite parent) {
        Group group = this.createGroup(parent, HibernateConsoleMessages.ConsoleConfigurationMainTab_property_file);
        this.propertyFileText = this.createBrowseEditor(parent, group);
        this.createSetupButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationMainTab.this.handlePropertyFileSetup();
            }
        });
    }

    private void createConfigurationFileEditor(Composite parent) {
        Group group = this.createGroup(parent, HibernateConsoleMessages.ConsoleConfigurationMainTab_configuration_file);
        this.configurationFileText = this.createBrowseEditor(parent, group);
        this.confbutton = this.createSetupButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationMainTab.this.handleConfigurationFileSetup();
            }
        });
    }

    private void createPersistenceUnitEditor(Composite parent) {
        Group group = this.createGroup(parent, HibernateConsoleMessages.ConsoleConfigurationMainTab_persistence_unit);
        this.persistenceUnitNameText = this.createBrowseEditor(parent, group);
        this.persistenceUnitNameButton = this.createBrowseButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationMainTab.this.handlePersistenceUnitBrowse();
            }
        });
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String projectName = this.nonEmptyTrimOrNull(this.projectNameText);
        configuration.setAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", this.getConfigurationMode().toString());
        configuration.setAttribute("org.hibernate.eclipse.launch.HIBERNATE_VERSION", this.getHibernateVersion());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        if (projectName != null) {
            configuration.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, Collections.singletonList(this.nonEmptyTrimOrNull(projectName)));
            configuration.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, Collections.singletonList(Integer.toString(4)));
        } else {
            configuration.removeAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS);
            configuration.removeAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES);
        }
        configuration.setAttribute("org.hibernate.eclipse.launch.PROPERTY_FILE", this.nonEmptyTrimOrNull(this.propertyFileText));
        configuration.setAttribute("org.hibernate.eclipse.launch.CFG_XML_FILE", this.nonEmptyTrimOrNull(this.configurationFileText));
        configuration.setAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", this.nonEmptyTrimOrNull(this.persistenceUnitNameText));
        String cpName = this.nonEmptyTrimOrNull(this.connectionProfileCtrl.getSelectedConnectionName());
        if (ConnectionProfileCtrl.JPA_CONNECTIN_NAME.equals(cpName)) {
            configuration.setAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE", Boolean.toString(true));
            configuration.removeAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME");
        } else if (ConnectionProfileCtrl.NO_CONNECTIN_NAME.equals(cpName)) {
            configuration.setAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", null);
            configuration.removeAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE");
        } else {
            configuration.setAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", cpName);
            configuration.removeAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ConsoleConfigurationPreferences.ConfigurationMode cm = ConsoleConfigurationPreferences.ConfigurationMode.parse((String)configuration.getAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ""));
            this.coreMode.setSelection(cm.equals(ConsoleConfigurationPreferences.ConfigurationMode.CORE));
            this.hibernateVersion.setText(configuration.getAttribute("org.hibernate.eclipse.launch.HIBERNATE_VERSION", ""));
            this.annotationsMode.setSelection(cm.equals(ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS));
            this.jpaMode.setSelection(cm.equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
            this.projectNameText.setText(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
            this.propertyFileText.setText(configuration.getAttribute("org.hibernate.eclipse.launch.PROPERTY_FILE", ""));
            this.configurationFileText.setText(configuration.getAttribute("org.hibernate.eclipse.launch.CFG_XML_FILE", ""));
            this.persistenceUnitNameText.setText(configuration.getAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", ""));
            if (Boolean.parseBoolean(configuration.getAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE", Boolean.toString(false)))) {
                this.connectionProfileCtrl.selectValue(ConnectionProfileCtrl.JPA_CONNECTIN_NAME);
            } else {
                this.connectionProfileCtrl.selectValue(configuration.getAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", ConnectionProfileCtrl.NO_CONNECTIN_NAME));
            }
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void handlePropertyFileSetup() {
        MessageDialog dialog;
        int answer;
        Path initialPath;
        int defaultChoice = 0;
        Path path = initialPath = this.getPropertyFilePath() != null ? this.getPropertyFilePath() : null;
        if (initialPath != null) {
            defaultChoice = 1;
        }
        if ((answer = (dialog = this.createSetupDialog(HibernateConsoleMessages.ConsoleConfigurationMainTab_setup_property_file, HibernateConsoleMessages.ConsoleConfigurationMainTab_do_you_want_to_create_new_property_file, defaultChoice)).open()) == 0) {
            this.handlePropertyFileCreate();
        } else if (answer == 1) {
            this.handlePropertyFileBrowse();
        }
    }

    private void handlePropertyFileBrowse() {
        Path initialPath = this.getPropertyFilePath() != null ? this.getPropertyFilePath() : new Path(this.getProjectName());
        IPath[] paths = org.hibernate.eclipse.console.utils.xpl.DialogSelectionHelper.chooseFileEntries(this.getShell(), (IPath)initialPath, new IPath[0], HibernateConsoleMessages.ConsoleConfigurationMainTab_select_propertyfile, HibernateConsoleMessages.ConsoleConfigurationMainTab_choose_file_to_use_as_hibernate_properties, new String[]{HibernateConsoleMessages.ConsoleConfigurationMainTab_properties}, false, false, true);
        if (paths != null && paths.length == 1) {
            this.propertyFileText.setText(paths[0].toOSString());
        }
    }

    private void handleProjectBrowse() {
        IJavaProject paths = DialogSelectionHelper.chooseJavaProject(this.getShell(), this.findJavaProject(), HibernateConsoleMessages.ConsoleConfigurationMainTab_select_java_project, HibernateConsoleMessages.ConsoleConfigurationMainTab_java_project_to_determine_default_classpath);
        if (paths != null) {
            this.projectNameText.setText(paths.getProject().getName());
        } else {
            this.projectNameText.setText("");
        }
    }

    private void handlePersistenceUnitBrowse() {
        String persistenceUnit = DialogSelectionHelper.choosePersistenceUnit(this.getShell(), this.persistenceUnitNameText.getText(), HibernateConsoleMessages.ConsoleConfigurationMainTab_select_persistence_unit, HibernateConsoleMessages.ConsoleConfigurationMainTab_jpa_selected_persistence_unit, this.findJavaProject());
        if (persistenceUnit != null) {
            this.persistenceUnitNameText.setText(persistenceUnit);
        } else {
            this.persistenceUnitNameText.setText("");
        }
    }

    private IJavaProject findJavaProject() {
        Path path = this.pathOrNull(this.getProjectName());
        if (path != null && path.segmentCount() >= 1) {
            String projectName = path.segment(0);
            return ProjectUtils.findJavaProject(projectName);
        }
        return null;
    }

    private void handlePropertyFileCreate() {
        Wizard wizard = new Wizard(){
            String pageName = HibernateConsoleMessages.ConsoleConfigurationMainTab_create_property_file;
            WizardNewFileCreationPage cPage = null;

            public void addPages() {
                StructuredSelection selection = null;
                IJavaProject project = ConsoleConfigurationMainTab.this.findJavaProject();
                selection = project != null ? new StructuredSelection((Object)project) : StructuredSelection.EMPTY;
                this.cPage = new WizardNewFileCreationPage(this.pageName, (IStructuredSelection)selection);
                this.cPage.setTitle(HibernateConsoleMessages.ConsoleConfigurationMainTab_create_hibernate_properties_file);
                this.cPage.setDescription(HibernateConsoleMessages.ConsoleConfigurationMainTab_create_new_properties_file);
                this.cPage.setFileName("hibernate.properties");
                this.addPage((IWizardPage)this.cPage);
            }

            public boolean performFinish() {
                IFile file = this.cPage.createNewFile();
                ConsoleConfigurationMainTab.this.propertyFileText.setText(file.getFullPath().toOSString());
                return true;
            }
        };
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
        wdialog.open();
    }

    private MessageDialog createSetupDialog(String title, String question, int defaultChoice) {
        return new MessageDialog(this.getShell(), title, null, question, 3, new String[]{HibernateConsoleMessages.ConsoleConfigurationMainTab_create_new, HibernateConsoleMessages.ConsoleConfigurationMainTab_use_existing, IDialogConstants.CANCEL_LABEL}, defaultChoice);
    }

    private void handleConfigurationFileSetup() {
        MessageDialog dialog;
        int answer;
        int defaultChoice = 0;
        if (this.getConfigurationFilePath() != null) {
            defaultChoice = 1;
        }
        if ((answer = (dialog = this.createSetupDialog(HibernateConsoleMessages.ConsoleConfigurationMainTab_setup_configuration_file, HibernateConsoleMessages.ConsoleConfigurationMainTab_do_you_want_to_create_new_cfgxml, defaultChoice)).open()) == 0) {
            this.handleConfigurationFileCreate();
        } else if (answer == 1) {
            this.handleConfigurationFileBrowse();
        }
    }

    private void handleConfigurationFileBrowse() {
        Path initialPath = this.getConfigurationFilePath() != null ? this.getConfigurationFilePath() : new Path(this.getProjectName());
        IPath[] paths = DialogSelectionHelper.chooseFileEntries(this.getShell(), (IPath)initialPath, new IPath[0], HibernateConsoleMessages.ConsoleConfigurationMainTab_select_hibernate_cfg_xml_file, HibernateConsoleMessages.ConsoleConfigurationMainTab_choose_file_to_use_as_hibernate_cfg_xml, new String[]{HibernateConsoleMessages.ConsoleConfigurationMainTab_cfg_xml}, false, false, true);
        if (paths != null && paths.length == 1) {
            this.configurationFileText.setText(paths[0].toOSString());
        }
    }

    private void handleConfigurationFileCreate() {
        WizardNewFileCreationPage createdFilePath;
        StructuredSelection selection = null;
        IJavaProject project = this.findJavaProject();
        selection = project != null ? new StructuredSelection((Object)project) : StructuredSelection.EMPTY;
        NewConfigurationWizard wizard = new NewConfigurationWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
        wdialog.create();
        IWizardPage configPage = wizard.getPage(HibernateConsoleMessages.ConsoleConfigurationMainTab_wizard_page);
        if (configPage != null && configPage instanceof NewConfigurationWizardPage) {
            ((NewConfigurationWizardPage)configPage).setCreateConsoleConfigurationVisible(false);
        }
        if (wdialog.open() == 0 && (createdFilePath = (WizardNewFileCreationPage)wizard.getStartingPage()) != null) {
            this.configurationFileText.setText(createdFilePath.createNewFile().getFullPath().toOSString());
        }
    }

    private Path pathOrNull(String p) {
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    public Path getConfigurationFilePath() {
        return this.pathOrNull(this.configurationFileText.getText());
    }

    public Path getPropertyFilePath() {
        String p = this.propertyFileText.getText();
        return this.pathOrNull(p);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String msg;
        this.setErrorMessage(null);
        this.setMessage(null);
        String propertyFilename = this.propertyFileText.getText();
        String configurationFilename = this.configurationFileText.getText();
        boolean modeJPA = this.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA);
        this.configurationFileText.setEnabled(!this.configurationFileWillBeCreated && !modeJPA);
        this.confbutton.setEnabled(!this.configurationFileWillBeCreated && !modeJPA);
        this.persistenceUnitNameText.setEnabled(modeJPA);
        this.persistenceUnitNameButton.setEnabled(modeJPA);
        String cpName = this.nonEmptyTrimOrNull(this.connectionProfileCtrl.getSelectedConnectionName());
        if (this.getProjectName() != null && StringHelper.isNotEmpty((String)this.getProjectName().trim())) {
            Path projectPath = new Path(this.getProjectName());
            if (projectPath.segmentCount() > 1) {
                this.setErrorMessage(HibernateConsoleMessages.ConsoleConfigurationMainTab_path_for_project_must_have_only_one_segment);
                return false;
            }
            IJavaProject findJavaProject = ProjectUtils.findJavaProject(this.getProjectName());
            if (findJavaProject == null || !findJavaProject.exists()) {
                String out = NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationMainTab_the_java_project_does_not_exist, (Object)this.getProjectName());
                this.setErrorMessage(out);
                return false;
            }
            if (ConnectionProfileCtrl.JPA_CONNECTIN_NAME.equals(cpName)) {
                JpaProject jpaProject = (JpaProject)findJavaProject.getAdapter(JpaProject.class);
                if (jpaProject == null) {
                    this.setErrorMessage(NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationMainTab_project_must_be_jpa, (Object)this.getProjectName()));
                    return false;
                }
                JpaDataSource ds = jpaProject.getDataSource();
                if (ds == null || "".equals(ds.getConnectionProfileName())) {
                    this.setErrorMessage(NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationMainTab_cp_not_specified, (Object)this.getProjectName()));
                    return false;
                }
            }
        } else if (ConnectionProfileCtrl.JPA_CONNECTIN_NAME.equals(cpName)) {
            this.setErrorMessage(HibernateConsoleMessages.ConsoleConfigurationMainTab_project_must_be_set);
            return false;
        }
        if (ConnectionProfileCtrl.JPA_CONNECTIN_NAME.equals(cpName) && !this.jpaMode.getSelection()) {
            String out = NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationMainTab_mode_must_be_used, (Object)this.jpaMode.getText());
            this.setErrorMessage(out);
            return false;
        }
        if (propertyFilename.length() > 0 && (msg = PathHelper.checkFile(propertyFilename, HibernateConsoleMessages.ConsoleConfigurationMainTab_property_file_2, true)) != null) {
            this.setErrorMessage(msg);
            return false;
        }
        if (!this.configurationFileWillBeCreated && configurationFilename.length() > 0 && (msg = PathHelper.checkFile(configurationFilename, HibernateConsoleMessages.ConsoleConfigurationMainTab_configuration_file_2, true)) != null) {
            this.setErrorMessage(msg);
            return false;
        }
        return true;
    }

    private ConsoleConfigurationPreferences.ConfigurationMode getConfigurationMode() {
        if (this.annotationsMode.getSelection()) {
            return ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS;
        }
        if (this.jpaMode.getSelection()) {
            return ConsoleConfigurationPreferences.ConfigurationMode.JPA;
        }
        return ConsoleConfigurationPreferences.ConfigurationMode.CORE;
    }

    public String getHibernateVersion() {
        return "".equals(this.hibernateVersion.getText()) ? null : this.hibernateVersion.getText();
    }

    String getProjectName() {
        return this.projectNameText.getText();
    }

    private String checkForFile(String msgPrefix, IResource resource) {
        if (resource != null) {
            if (resource instanceof IFile) {
                return null;
            }
            return NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationMainTab_is_not_file, (Object)msgPrefix);
        }
        return NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationMainTab_does_not_exist, (Object)msgPrefix);
    }

    public Image getImage() {
        return EclipseImages.getImage("images/hicon.gif");
    }

    public void markConfigurationFileWillBeCreated() {
        this.configurationFileWillBeCreated = true;
        this.confbutton.setEnabled(false);
        this.configurationFileText.setEnabled(false);
    }
}

