/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.shell.util.OSUtils;

public class PathspecParser {
    private int cursor;
    private final int length;
    private final ResourceFactory factory;
    private final Resource<?> res;
    private final String path;
    private final boolean isWindows = OSUtils.isWindows();
    List<Resource<?>> results = new LinkedList();

    public PathspecParser(ResourceFactory factory, Resource<?> res, String path) {
        this.factory = factory;
        this.res = res;
        this.path = path;
        this.length = path.length();
    }

    private PathspecParser(ResourceFactory factory, Resource<?> res, String path, int cursor) {
        this.factory = factory;
        this.res = res;
        this.path = path;
        this.length = path.length();
        this.cursor = cursor;
    }

    public List<Resource<?>> resolve() {
        Resource<File> r = this.res;
        char slashChar = File.separatorChar;
        String slashString = File.separator;
        if (".".equals(this.path)) {
            return PathspecParser.singleResult(r);
        }
        if (this.path.startsWith("~")) {
            File homeDir = new File(System.getProperty("user.home")).getAbsoluteFile();
            if (this.path.length() == 1) {
                return PathspecParser.singleResult(new DirectoryResource(this.factory, homeDir));
            }
            ++this.cursor;
            r = new DirectoryResource(this.factory, homeDir);
        } else if (this.isWindows && this.path.matches("^[a-zA-Z]{1,1}:(/|\\\\).*")) {
            int idx = this.path.indexOf(slashChar) + 1;
            r = new DirectoryResource(this.factory, new File(this.path.substring(0, idx)).getAbsoluteFile());
            this.cursor = idx;
        }
        block7: while (this.cursor < this.length) {
            Resource<?> child;
            switch (this.path.charAt(this.cursor++)) {
                case '/': 
                case '\\': {
                    if (this.cursor - 1 != 0) continue block7;
                    r = this.factory.getResourceFrom(new File(slashString).getAbsoluteFile());
                    continue block7;
                }
                case '.': {
                    switch (this.read()) {
                        case '.': {
                            ++this.cursor;
                            Resource<?> parent = r.getParent();
                            if (parent == null) continue block7;
                            r = parent;
                            continue block7;
                        }
                    }
                    if (this.cursor >= this.length || this.path.charAt(this.cursor) != slashChar) break;
                    ++this.cursor;
                    continue block7;
                }
            }
            boolean first = --this.cursor == 0;
            String tk = this.capture();
            if (tk.matches(".*(\\?|\\*)+.*")) {
                boolean startDot = tk.startsWith(".");
                String regex = PathspecParser.pathspecToRegEx(tk.startsWith(slashString) ? tk.substring(1) : tk);
                Pattern p = Pattern.compile(regex);
                LinkedList res = new LinkedList();
                for (Resource<Object> child2 : r.listResources()) {
                    if (!p.matcher(child2.getName()).matches()) continue;
                    child2.setFlag(ResourceFlag.AmbiguouslyQualified);
                    if (child2.getName().startsWith(".")) {
                        if (!startDot) continue;
                        res.add(child2);
                        continue;
                    }
                    res.add(child2);
                }
                if (this.cursor != this.length) {
                    for (Resource<Object> child2 : res) {
                        this.results.addAll(new PathspecParser(this.factory, child2, this.path, this.cursor).resolve());
                    }
                } else {
                    this.results.addAll(res);
                }
                return this.results;
            }
            if (tk.startsWith(slashString)) {
                if (first) {
                    r = this.factory.getResourceFrom(new File(tk));
                    ++this.cursor;
                    continue;
                }
                tk = tk.substring(1);
            }
            if ((child = r.getChild(tk)) == null) {
                throw new RuntimeException("no such child: " + child);
            }
            r = child;
        }
        return PathspecParser.singleResult(r);
    }

    public List<Resource<?>> search() {
        return PathspecParser.match(this.path.split(Pattern.quote(File.separator)), 0, this.res, new LinkedList());
    }

    private static List<Resource<?>> match(String[] matchLevels, int nestStart, Resource<?> res, List<Resource<?>> candidates) {
        String regex = PathspecParser.pathspecToRegEx(matchLevels[nestStart]);
        Pattern matchPattern = Pattern.compile(regex);
        if (matchPattern.matcher(res.getName()).matches()) {
            if (nestStart < matchLevels.length && res.isFlagSet(ResourceFlag.Node)) {
                return PathspecParser.match(matchLevels, nestStart + 1, res, candidates);
            }
            candidates.add(res);
            return candidates;
        }
        if (!res.isFlagSet(ResourceFlag.Node) || nestStart == matchLevels.length) {
            return candidates;
        }
        for (Resource<?> r : res.listResources()) {
            PathspecParser.match(matchLevels, nestStart, r, candidates);
        }
        return candidates;
    }

    private static List<Resource<?>> singleResult(Resource<?> item) {
        return Collections.singletonList(item);
    }

    private char read() {
        if (this.cursor != this.length) {
            return this.path.charAt(this.cursor);
        }
        return '\u0000';
    }

    private String capture() {
        int start = this.cursor;
        if (this.path.charAt(this.cursor) == '/') {
            ++this.cursor;
        }
        while (this.cursor < this.length && this.path.charAt(this.cursor) != '/') {
            ++this.cursor;
        }
        return this.path.substring(start, this.cursor);
    }

    public static String pathspecToRegEx(String pathSpec) {
        StringBuilder sb = new StringBuilder("^");
        block5: for (int i = 0; i < pathSpec.length(); ++i) {
            char c = pathSpec.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.append("$").toString();
    }
}

