/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.util.Strings;

public class Refactory {
    public static void createGetterAndSetter(JavaClass clazz, Field<JavaClass> field) {
        if (!clazz.hasField(field)) {
            throw new IllegalArgumentException("Entity did not contain the given field [" + field + "]");
        }
        clazz.getMethods();
        String fieldName = field.getName();
        String methodNameSuffix = Strings.capitalize(fieldName);
        ((Method)clazz.addMethod().setReturnType(field.getTypeInspector().toString()).setName("get" + methodNameSuffix).setPublic()).setBody("return this." + fieldName + ";");
        if (!field.isFinal()) {
            ((Method)clazz.addMethod().setReturnTypeVoid().setName("set" + methodNameSuffix).setPublic()).setParameters("final " + field.getTypeInspector().toString() + " " + fieldName).setBody("this." + fieldName + " = " + fieldName + ";");
        }
    }

    public static void createHashCodeAndEquals(JavaClass clazz) {
        clazz.addMethod("public boolean equals(Object that) { if (this == that) { return true; } if (that == null) { return false; } if (getClass() != that.getClass()) { return false; } if (id != null) { return id.equals(((" + clazz.getName() + ") that).id); } " + "return super.equals(that); " + "}").addAnnotation(Override.class);
        clazz.addMethod("public int hashCode() { if (id != null) { return id.hashCode(); } return super.hashCode(); }").addAnnotation(Override.class);
    }

    public static void createToStringFromFields(JavaClass clazz) {
        List<Field<JavaClass>> fields = clazz.getFields();
        Refactory.createToStringFromFields(clazz, fields);
    }

    public static void createToStringFromFields(JavaClass clazz, Field<JavaClass> ... fields) {
        Refactory.createToStringFromFields(clazz, Arrays.asList(fields));
    }

    public static void createToStringFromFields(JavaClass clazz, List<Field<JavaClass>> fields) {
        Method method = (Method)clazz.addMethod().setName("toString").setReturnType(String.class).setPublic();
        method.addAnnotation(Override.class);
        ArrayList<String> list = new ArrayList<String>();
        String delimeter = "\n";
        for (Field<JavaClass> field : fields) {
            if (!clazz.hasField(field)) continue;
            StringBuilder line = new StringBuilder();
            if (!field.isPrimitive()) {
                if (field.isType(String.class)) {
                    line.append("if(").append(field.getName()).append(" != null && !").append(field.getName()).append(".trim().isEmpty())\n");
                } else {
                    line.append("if(").append(field.getName()).append(" != null)\n");
                }
            }
            boolean isFirst = list.isEmpty();
            line.append(" result += ").append(isFirst ? "\"" : "\", ");
            line.append(field.getName()).append(": \" + ").append(field.getName()).append(";");
            list.add(line.toString());
        }
        String body = "String result = getClass().getSimpleName()+\" \";\n" + Strings.join(list, delimeter) + "\n" + "return result;";
        method.setBody(body);
    }
}

