/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.exception.control;

import org.jboss.solder.exception.control.ExceptionStack;

public class CaughtException<T extends Throwable> {
    private final ExceptionStack exceptionStack;
    private final T exception;
    private boolean unmute;
    private ExceptionHandlingFlow flow;
    private Throwable throwNewException;
    private final boolean breadthFirstTraversal;
    private final boolean depthFirstTraversal;
    private final boolean markedHandled;

    public CaughtException(ExceptionStack exceptionStack, boolean breadthFirstTraversal, boolean handled) {
        if (exceptionStack == null) {
            throw new IllegalArgumentException("null is not valid for exceptionStack");
        }
        this.exception = exceptionStack.getCurrent();
        this.exceptionStack = exceptionStack;
        this.breadthFirstTraversal = breadthFirstTraversal;
        this.depthFirstTraversal = !breadthFirstTraversal;
        this.markedHandled = handled;
        this.flow = ExceptionHandlingFlow.MARK_HANDLED;
    }

    public T getException() {
        return this.exception;
    }

    public void abort() {
        this.flow = ExceptionHandlingFlow.ABORT;
    }

    public void rethrow() {
        this.flow = ExceptionHandlingFlow.RETHROW;
    }

    public void handled() {
        this.flow = ExceptionHandlingFlow.HANDLED;
    }

    public void markHandled() {
        this.flow = ExceptionHandlingFlow.MARK_HANDLED;
    }

    public void dropCause() {
        this.flow = ExceptionHandlingFlow.DROP_CAUSE;
    }

    public void unmute() {
        this.unmute = true;
    }

    public boolean isBreadthFirstTraversal() {
        return this.breadthFirstTraversal;
    }

    public boolean isDepthFirstTraversal() {
        return this.depthFirstTraversal;
    }

    protected boolean isUnmute() {
        return this.unmute;
    }

    public ExceptionStack getExceptionStack() {
        return this.exceptionStack;
    }

    protected ExceptionHandlingFlow getFlow() {
        return this.flow;
    }

    public boolean isMarkedHandled() {
        return this.markedHandled;
    }

    public void rethrow(Throwable t) {
        this.throwNewException = t;
        this.flow = ExceptionHandlingFlow.THROW;
    }

    protected Throwable getThrowNewException() {
        return this.throwNewException;
    }

    protected static enum ExceptionHandlingFlow {
        HANDLED,
        MARK_HANDLED,
        DROP_CAUSE,
        ABORT,
        RETHROW,
        THROW;

    }
}

