/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.fshparser;

import org.jboss.forge.shell.command.fshparser.LogicalStatement;
import org.jboss.forge.shell.command.fshparser.Node;
import org.jboss.forge.shell.command.fshparser.Parse;
import org.jboss.forge.shell.command.fshparser.PipeNode;
import org.jboss.forge.shell.command.fshparser.ScriptNode;
import org.jboss.forge.shell.command.fshparser.StatementTerminator;
import org.jboss.forge.shell.command.fshparser.StringTokenNode;
import org.jboss.forge.shell.command.fshparser.TokenNode;
import org.mvel2.util.ParseTools;
import org.mvel2.util.StringAppender;

public class FSHParser {
    private char[] expr;
    private int cursor;
    private final int length;
    private Node firstNode;
    private Node node;
    private boolean nest = false;

    public FSHParser(String expr) {
        this.expr = expr.toCharArray();
        this.length = this.expr.length;
    }

    public FSHParser(String expr, boolean nest) {
        this.expr = expr.toCharArray();
        this.length = this.expr.length;
        this.nest = nest;
    }

    public Node parse() {
        LogicalStatement n;
        while ((n = this.captureLogicalStatement()) != null) {
            this.addNode(n);
        }
        return this.firstNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Node nextNode() {
        Node node;
        this.skipWhitespace();
        int start = this.cursor;
        if (this.cursor >= this.length) {
            return null;
        }
        if (this.expr[this.cursor] == ';') {
            ++this.cursor;
            return new StatementTerminator();
        }
        switch (this.expr[this.cursor]) {
            case '@': {
                this.skipToEOS();
                String scriptTk = new String(this.expr, ++start, this.cursor - start);
                return new ScriptNode(new TokenNode(scriptTk), true);
            }
            case '\"': 
            case '\'': {
                this.cursor = ParseTools.balancedCapture((char[])this.expr, (int)this.cursor, (char)this.expr[this.cursor]);
                return new StringTokenNode(new String(this.expr, start + 1, this.cursor++ - start - 1));
            }
            case '(': {
                this.cursor = ParseTools.balancedCapture((char[])this.expr, (int)this.cursor, (char)this.expr[this.cursor]);
                return new FSHParser(new String(this.expr, ++start, this.cursor++ - start), true).parse();
            }
        }
        String tk = this.captureToken();
        if (Parse.isReservedWord(tk)) {
            boolean block = "for".equals(tk) || "if".equals(tk) || "while".equals(tk) || "def".equals(tk);
            start = this.cursor;
            block9: while (this.cursor <= this.length) {
                switch (this.expr[this.cursor]) {
                    case '\"': 
                    case '\'': 
                    case '(': {
                        this.cursor = ParseTools.balancedCapture((char[])this.expr, (int)this.cursor, (char)this.expr[this.cursor]);
                        if (!block) break;
                        ++this.cursor;
                        while (this.cursor != this.length && Character.isWhitespace(this.expr[this.cursor])) {
                            ++this.cursor;
                        }
                        StringAppender buf = new StringAppender("def".equals(tk) ? " " : "");
                        if (this.cursor == this.length) break;
                        do {
                            boolean openBracket;
                            boolean bl = openBracket = this.expr[this.cursor] == '{';
                            if (openBracket) {
                                ++this.cursor;
                            }
                            buf.append(this.shellToMVEL(new String(this.expr, start, this.cursor - start - (openBracket ? 1 : 0)), true));
                            if (openBracket) {
                                buf.append('{');
                            }
                            start = this.cursor;
                            if (openBracket) {
                                this.cursor = ParseTools.balancedCapture((char[])this.expr, (int)this.cursor, (char)'{');
                            } else {
                                while (this.cursor != this.length && this.expr[this.cursor] != ';') {
                                    ++this.cursor;
                                }
                            }
                            int offset = this.cursor != this.length && this.expr[this.cursor] == '}' ? -1 : 0;
                            buf.append(this.shellToMVEL(new String(this.expr, start, this.cursor - start).trim(), false));
                            if (offset == -1) {
                                buf.append("}");
                                ++this.cursor;
                            }
                            tk = tk + buf.toString();
                            buf.reset();
                            start = this.cursor;
                        } while (this.ifThenElseBlockContinues());
                        return new ScriptNode(new TokenNode(tk), true);
                    }
                    case ';': {
                        break block9;
                    }
                }
                ++this.cursor;
            }
            tk = tk + new String(this.expr, start, this.cursor - start);
        }
        if (tk.startsWith("$")) {
            node = new ScriptNode(new TokenNode(tk), false);
            return node;
        }
        node = new TokenNode(tk);
        return node;
    }

    protected boolean ifThenElseBlockContinues() {
        this.skipWhitespace();
        if (this.cursor + 4 < this.length) {
            if (this.expr[this.cursor] != ';') {
                --this.cursor;
            }
            this.skipWhitespace();
            if (this.expr[this.cursor] == 'e' && this.expr[this.cursor + 1] == 'l' && this.expr[this.cursor + 2] == 's' && this.expr[this.cursor + 3] == 'e' && (ParseTools.isWhitespace((char)this.expr[this.cursor + 4]) || this.expr[this.cursor + 4] == '{')) {
                this.cursor += 4;
                this.skipWhitespace();
                if (this.cursor + 1 < this.length && this.expr[this.cursor] == 'i' && this.expr[this.cursor + 1] == 'f') {
                    this.cursor += 2;
                    this.expectNext('(');
                    this.cursor = ParseTools.balancedCapture((char[])this.expr, (int)this.cursor, (char)'(') + 1;
                }
                this.skipWhitespace();
                return true;
            }
        }
        return false;
    }

    private LogicalStatement captureLogicalStatement() {
        Node d;
        if (this.cursor >= this.length) {
            return null;
        }
        Node start = null;
        Node n = null;
        boolean pipe = false;
        boolean script = false;
        boolean nocommand = false;
        while ((d = this.nextNode()) != null && !(d instanceof StatementTerminator)) {
            if (start == null) {
                n = d;
                start = n;
            }
            if (FSHParser.tokenMatch(d, "|")) {
                pipe = true;
                break;
            }
            if (this.nest && !script && FSHParser.tokenIsOperator(d) || FSHParser.tokenMatch(d, "=")) {
                script = true;
            }
            if (n == d) continue;
            Node node = n;
            n = d;
            node.setNext(n);
        }
        LogicalStatement logicalStatement = new LogicalStatement(script ? new ScriptNode(start, nocommand) : start);
        if (pipe) {
            PipeNode pipeNode = new PipeNode(this.captureLogicalStatement());
            logicalStatement.setNext(pipeNode);
        }
        return logicalStatement;
    }

    private String shellToMVEL(String subStmt, boolean noShellCall) {
        StringAppender buf = new StringAppender();
        boolean stmtStart = true;
        boolean openShellCall = false;
        boolean scriptOnly = false;
        Nest nest = new Nest();
        block13: for (int i = 0; i < subStmt.length(); ++i) {
            if (stmtStart) {
                while (i < subStmt.length() && ParseTools.isWhitespace((char)subStmt.charAt(i))) {
                    ++i;
                }
                if (i >= subStmt.length()) break;
                int firstToken = this.getEndOfToken(subStmt, i);
                String tk = subStmt.substring(i, firstToken).trim();
                if (!(noShellCall || tk.charAt(0) == '@' || firstToken != -1 && Parse.isReservedWord(tk))) {
                    buf.append("shell(\"");
                    openShellCall = true;
                } else {
                    scriptOnly = true;
                    stmtStart = false;
                    if (tk.charAt(0) == '@') continue;
                }
                stmtStart = false;
            }
            switch (subStmt.charAt(i)) {
                case '\\': {
                    buf.append("\\");
                    if (nest.isLiteral()) {
                        buf.append("\\");
                    }
                    buf.append(subStmt.charAt(++i));
                    if (subStmt.charAt(i) != '\\') continue block13;
                    buf.append("\\");
                    continue block13;
                }
                case '\'': {
                    nest.nestSingleQuote();
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case '\"': {
                    nest.nestDoubleQuote();
                    if (openShellCall) {
                        buf.append("\\\"");
                        continue block13;
                    }
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case '(': {
                    if (!nest.isLiteral()) {
                        ++nest.bracket;
                    }
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case '{': {
                    buf.append(subStmt.charAt(i));
                    if (nest.isLiteral()) continue block13;
                    int start = ++i;
                    i = ParseTools.balancedCapture((char[])subStmt.toCharArray(), (int)i, (char)'{');
                    buf.append(this.shellToMVEL(subStmt.substring(start, i), false)).append('}');
                    continue block13;
                }
                case '[': {
                    if (!nest.isLiteral()) {
                        ++nest.square;
                    }
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case ')': {
                    if (!nest.isLiteral()) {
                        --nest.bracket;
                    }
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case '}': {
                    if (!nest.isLiteral()) {
                        --nest.curly;
                    }
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case ']': {
                    if (!nest.isLiteral()) {
                        --nest.square;
                    }
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case ';': {
                    if (!nest.isLiteral()) {
                        if (openShellCall) {
                            buf.append("\")");
                            openShellCall = false;
                        }
                        stmtStart = true;
                        scriptOnly = false;
                    }
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                case '$': {
                    int start;
                    if (!scriptOnly) {
                        buf.append("\"+");
                        start = ++i;
                        i = FSHParser.captureToken(i, subStmt.length(), subStmt.toCharArray());
                        buf.append(subStmt.substring(start, i));
                        if (i < subStmt.length()) {
                            buf.append("+\"");
                            --i;
                            continue block13;
                        }
                        buf.append(")");
                        openShellCall = false;
                        continue block13;
                    }
                    if (++i >= subStmt.length()) continue block13;
                    buf.append(subStmt.charAt(i));
                    continue block13;
                }
                default: {
                    buf.append(subStmt.charAt(i));
                }
            }
        }
        if (nest.isLiteral()) {
            throw new RuntimeException("unterminated string literal while parsing script");
        }
        if (nest.isNested()) {
            throw new RuntimeException("unterminated nest while parsing script");
        }
        if (openShellCall) {
            buf.append("\")");
        }
        return buf.toString();
    }

    private int getEndOfToken(String s, int offset) {
        return FSHParser.captureToken(offset, s.length(), s.toCharArray());
    }

    private String captureToken() {
        int start = this.cursor;
        this.cursor = FSHParser.captureToken(this.cursor, this.length, this.expr);
        return new String(this.expr, start, this.cursor - start).replace("\\ ", " ");
    }

    private static int captureToken(int cursor, int length, char[] expr) {
        if (cursor >= length) {
            return length;
        }
        int start = cursor;
        if (Parse.isTokenPart(expr[cursor])) {
            boolean capturing = true;
            while (true) {
                if (cursor != length && Parse.isTokenPart(expr[cursor])) {
                    if (expr[cursor] == '\\' && cursor + 1 < length && expr[cursor + 1] == ' ') {
                        ++cursor;
                    }
                    ++cursor;
                    continue;
                }
                if (cursor == length) {
                    capturing = false;
                } else {
                    char c = FSHParser.nextNonBlank(cursor, expr);
                    if (c == '\uffffffff' || expr[cursor] != '(' && expr[cursor] != '[') {
                        capturing = false;
                    } else {
                        cursor = ParseTools.balancedCapture((char[])expr, (int)cursor, (char)expr[cursor]) + 1;
                    }
                }
                if (!capturing) break;
            }
        } else {
            block4: while (cursor != length) {
                switch (expr[cursor]) {
                    case '\t': 
                    case '\r': 
                    case ' ': 
                    case ';': 
                    case '=': {
                        break block4;
                    }
                    default: {
                        if (Parse.isTokenPart(expr[cursor])) break block4;
                        ++cursor;
                        continue block4;
                    }
                }
            }
        }
        if (cursor == start) {
            ++cursor;
        }
        return cursor;
    }

    private void skipWhitespace() {
        while (this.cursor < this.length && ParseTools.isWhitespace((char)this.expr[this.cursor])) {
            ++this.cursor;
        }
    }

    public void skipToEOS() {
        while (this.cursor < this.length && this.expr[this.cursor] != ';') {
            switch (this.expr[this.cursor]) {
                case '\"': 
                case '\'': 
                case '(': 
                case '{': {
                    this.cursor = ParseTools.balancedCapture((char[])this.expr, (int)this.cursor, (char)this.expr[this.cursor]);
                }
            }
            ++this.cursor;
        }
    }

    private void addNode(Node n) {
        if (this.node == null) {
            this.firstNode = this.node = n;
        } else {
            this.node = n;
            this.node.setNext(this.node);
        }
    }

    private void expectNext(char c) {
        while (this.cursor != this.length && this.expr[this.cursor] != c) {
            ++this.cursor;
        }
        if (this.cursor == this.length || this.expr[this.cursor] != c) {
            throw new RuntimeException("expected '('");
        }
    }

    private static char nextNonBlank(int cursor, char[] expr) {
        while (cursor != expr.length && ParseTools.isWhitespace((char)expr[cursor])) {
            ++cursor;
        }
        if (cursor == expr.length) {
            return '\uffff';
        }
        return expr[cursor];
    }

    private static boolean tokenIsOperator(Node n) {
        return n instanceof TokenNode && Parse.isOperator(((TokenNode)n).getValue());
    }

    public static boolean tokenMatch(Node n, String text) {
        return n instanceof TokenNode && ((TokenNode)n).getValue().equals(text);
    }

    private static class Nest {
        int bracket = 0;
        int curly = 0;
        int square = 0;
        int doubleQuote = 0;
        int singleQuote = 0;

        private Nest() {
        }

        boolean isNested() {
            return this.bracket + this.curly + this.square != 0;
        }

        boolean isLiteral() {
            return this.doubleQuote + this.singleQuote != 0;
        }

        public void nestDoubleQuote() {
            this.doubleQuote = this.doubleQuote == 0 ? 1 : 0;
        }

        public void nestSingleQuote() {
            this.singleQuote = this.singleQuote == 0 ? 1 : 0;
        }
    }
}

