/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.hibernate.eclipse.console.HibernateConsoleMessages;

public class PathHelper {
    public static String getLocationAsStringPath(String path) {
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource member = PathHelper.findMember(root, path);
        if (member == null) {
            if (new File(path).exists()) {
                return path;
            }
            return null;
        }
        return PathHelper.getLocation(member).toOSString();
    }

    public static IResource findMember(IWorkspaceRoot root, String path) {
        IContainer[] findContainersForLocation;
        Path pathOrNull = PathHelper.pathOrNull(path);
        if (pathOrNull == null) {
            return null;
        }
        IResource findMember = root.findMember((IPath)pathOrNull);
        if (findMember == null && (findContainersForLocation = root.findContainersForLocation((IPath)pathOrNull)).length > 0) {
            findMember = findContainersForLocation[0];
        }
        return findMember;
    }

    public static IPath getLocation(IResource resource) {
        if (resource.getRawLocation() == null) {
            return resource.getLocation();
        }
        return resource.getRawLocation();
    }

    private static String resolve(String expression) {
        if (expression == null) {
            return null;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return variableManager.performStringSubstitution(expression, false);
        }
        catch (CoreException coreException) {
            return expression;
        }
    }

    public static Path pathOrNull(String p) {
        return PathHelper.pathOrNull(p, false);
    }

    public static Path pathOrNull(String p, boolean resolveVariables) {
        if (resolveVariables && p != null) {
            p = PathHelper.resolve(p);
        }
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkDirectory(String strpath, String name, boolean checkFilesystem) {
        IProject proj;
        File file;
        if (strpath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(strpath);
            }
            catch (CoreException e) {
                return NLS.bind((String)HibernateConsoleMessages.PathHelper_has_invalid_variable_references, (Object)name, (Object)e.getMessage());
            }
        }
        Path path = PathHelper.pathOrNull(PathHelper.resolve(strpath));
        if (checkFilesystem && path != null && (file = new File(path.toOSString())).exists()) {
            if (!file.isDirectory()) return NLS.bind((String)HibernateConsoleMessages.PathHelper_not_directory, (Object)path);
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (res == null) return NLS.bind((String)HibernateConsoleMessages.PathHelper_does_not_exist, (Object)name, (Object)path);
        int resType = res.getType();
        if (resType != 4) {
            if (resType != 2) return NLS.bind((String)HibernateConsoleMessages.PathHelper_has_to_be_folder_or_project, (Object)name, (Object)path);
        }
        if ((proj = res.getProject()).isOpen()) return null;
        return NLS.bind((String)HibernateConsoleMessages.PathHelper_project_for_is_closed, (Object)name, (Object)path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkFile(String strpath, String name, boolean checkFilesystem) {
        File file;
        if (strpath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(strpath);
            }
            catch (CoreException e) {
                return NLS.bind((String)HibernateConsoleMessages.PathHelper_has_invalid_variable_references, (Object)name, (Object)e.getMessage());
            }
        }
        Path path = PathHelper.pathOrNull(PathHelper.resolve(strpath));
        if (checkFilesystem && path != null && (file = new File(path.toOSString())).exists()) {
            if (!file.isFile()) return NLS.bind((String)HibernateConsoleMessages.PathHelper_not_file, (Object)path);
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (res == null) return NLS.bind((String)HibernateConsoleMessages.PathHelper_does_not_exist, (Object)name, (Object)path);
        int resType = res.getType();
        if (resType != 1) return NLS.bind((String)HibernateConsoleMessages.PathHelper_has_to_be_file, (Object)name, (Object)path);
        IProject proj = res.getProject();
        if (proj.isOpen()) return null;
        return NLS.bind((String)HibernateConsoleMessages.PathHelper_project_for_is_closed, (Object)name, (Object)path);
    }
}

