/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.core.jdt.FavoritesClassController;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueEditor;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.editor.EditorMessages;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class JavaFavoritesFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IValueEditor,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    protected String filter;
    protected String javaProjectName;
    private Label classListLabel;
    private TableViewer classList;
    private Object[] elements;

    public JavaFavoritesFieldEditor() {
    }

    public JavaFavoritesFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 1;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getControl(parent)};
    }

    protected Control getControl(Composite parent) {
        List<String> favoritesClasses = FavoritesClassController.getFavoritesClassesList();
        Object[] typeRefs = favoritesClasses.toArray(new Object[favoritesClasses.size()]);
        this.elements = typeRefs;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.classListLabel = new Label(composite, 0);
        this.classListLabel.setText(EditorMessages.getString("JavaFavoritesChoicerFieldEditor.ClassesList.Label"));
        this.classList = this.createList(composite);
        return composite;
    }

    protected TableViewer createList(Composite parent) {
        int flags = 2820;
        this.classList = new TableViewer(parent, flags);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.classList.getControl().setLayoutData((Object)data);
        this.classList.getControl().setFont(parent.getFont());
        this.classList.setLabelProvider((IBaseLabelProvider)FavoritesClassController.getLabelProvider());
        this.classList.setContentProvider((IContentProvider)new FavoritesClassesContentProvider());
        this.classList.setInput((Object)"Go!");
        this.classList.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaFavoritesFieldEditor.this.handleSelected(event);
            }
        });
        this.classList.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (JavaFavoritesFieldEditor.this.getOwnerDialog() != null) {
                    JavaFavoritesFieldEditor.this.getOwnerDialog().okPressed();
                }
            }
        });
        return this.classList;
    }

    protected void handleSelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.classList.getSelection();
        Object obj = selection.getFirstElement();
        if (obj != null) {
            String selectionClass = (String)obj;
            PropertyChangeEvent changeEvent = new PropertyChangeEvent(this, "IPropertyEditor.value", null, selectionClass);
            this.valueProvider.removeValueChangeListener(this);
            this.valueChangeListener.valueChange(changeEvent);
            this.valueProvider.addValueChangeListener(this);
        }
    }

    protected void handleValueProviderValueChange(PropertyChangeEvent event) {
    }

    @Override
    public void setValueChangeListener(IValueChangeListener valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }

    @Override
    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
        valueProvider.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("IPropertyEditor.value".equals(event.getPropertyName())) {
                    JavaFavoritesFieldEditor.this.handleValueProviderValueChange(event);
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueProvider.addValueChangeListener(this);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void delete() {
    }

    class FavoritesClassesContentProvider
    implements IStructuredContentProvider {
        FavoritesClassesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return JavaFavoritesFieldEditor.this.elements;
        }
    }
}

