/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.DialogCellEditorEx;
import org.jboss.tools.common.model.ui.attribute.editor.JavaAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.JavaEclipseChoicerEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkCueLabelProvider;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class JavaHyperlinkCellEditor
extends DialogCellEditorEx
implements JavaHyperlinkCueLabelProvider.JavaClassHolder {
    private IProject project;
    private String publicId;
    private String xPath;
    boolean classExists;
    String textCache = null;
    long timeStamp = -1L;

    public JavaHyperlinkCellEditor() {
    }

    public JavaHyperlinkCellEditor(Composite parent) {
        super(parent);
    }

    public JavaHyperlinkCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void setPropertyEditor(PropertyEditor propertyEditor) {
        super.setPropertyEditor(propertyEditor);
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            if (this.valueProvider instanceof DefaultValueAdapter && ((DefaultValueAdapter)this.valueProvider).getModel() != null) {
                XAttribute attr;
                IProject project;
                XModelObject xmo = FileSystemsHelper.getFileSystems((XModel)((DefaultValueAdapter)this.valueProvider).getModel());
                if (xmo != null && (project = (IProject)xmo.getModel().getProperties().get("project")) != null) {
                    this.project = project;
                }
                if ((xmo = ((DefaultValueAdapter)this.valueProvider).getModelObject()) != null) {
                    this.publicId = XModelObjectUtil.getDocumentPublicID((XModelObject)xmo);
                }
                if ((attr = ((DefaultValueAdapter)this.valueProvider).getAttribute()) != null) {
                    this.xPath = XModelObjectUtil.getXMLLocalPath((XAttribute)attr);
                }
            }
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        }
    }

    protected Text getTextField() {
        return this.text;
    }

    @Override
    public boolean canCreateClass() {
        String text;
        String string = this.getTextField() != null ? this.getTextField().getText() : (text = this.valueProvider != null ? this.valueProvider.getStringValue(true) : null);
        if (text == null) {
            return false;
        }
        if (text.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch != '.' && !Character.isJavaIdentifierPart(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean classExists() {
        String text;
        String string = this.getTextField() != null ? this.getTextField().getText() : (text = this.valueProvider != null ? this.valueProvider.getStringValue(true) : null);
        if (text == null || text.length() == 0) {
            return false;
        }
        JavaAdapter javaAdapter = JavaAdapter.getInstance();
        if (text.equals(this.textCache) && this.timeStamp == javaAdapter.lastTimeChange) {
            return this.classExists;
        }
        javaAdapter.init(this.project, this.publicId, this.xPath, text);
        this.timeStamp = javaAdapter.lastTimeChange;
        this.textCache = text;
        this.classExists = javaAdapter.getJavaElement() != null;
        return this.classExists;
    }

    public Object callExternal(Shell shell) {
        if (this.propertyEditor instanceof JavaEclipseChoicerEditor) {
            return ((JavaEclipseChoicerEditor)this.propertyEditor).callExternal(shell);
        }
        return null;
    }
}

