/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.util.Properties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.model.ui.ModelUIMessages;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.attribute.editor.IMutableFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.MultipleChoiceFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class MutableMultipleChoiceFieldEditor
extends MultipleChoiceFieldEditor
implements CommandBarListener,
IMutableFieldEditor {
    static String NEW = ModelUIMessages.MutableMultipleChoiceFieldEditor_New;
    static String SELECT_ALL = ModelUIMessages.MutableMultipleChoiceFieldEditor_SelectAll;
    static String DESELECT_ALL = ModelUIMessages.MutableMultipleChoiceFieldEditor_DeselectAll;
    CommandBar bar = new CommandBar();
    String[] commands = new String[]{NEW, SELECT_ALL, DESELECT_ALL};
    private Composite composite;
    private SpecialWizard change;

    public MutableMultipleChoiceFieldEditor() {
        this(null);
    }

    public MutableMultipleChoiceFieldEditor(IWidgetSettings settings) {
        super(settings);
        this.bar.setCommands(this.commands);
        this.bar.getLayout().direction = 512;
        this.bar.getLayout().setMargins(0, 0, 0, 0);
        this.bar.addCommandBarListener(this);
        this.bar.setWidgetSettings(settings);
    }

    @Override
    public void setChange(SpecialWizard change) {
        this.change = change;
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.getListControl().getLayoutData();
        gd.horizontalSpan = numColumns - 2;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Composite control = this.getListChangeControl(parent);
        control.setLayoutData((Object)new GridData(768));
    }

    protected Composite getListChangeControl(Composite parent) {
        this.createListChangeControl(parent);
        return this.composite;
    }

    protected Control createListChangeControl(Composite parent) {
        if (this.composite == null) {
            this.composite = new Composite(parent, 0);
        }
        this.composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        Composite listControl = this.createListControl(this.composite);
        GridData gd = new GridData(1808);
        listControl.setLayoutData((Object)gd);
        Label control = new Label(this.composite, 0);
        control.setBackground(parent.getBackground());
        gd = new GridData();
        gd.widthHint = 5;
        control.setLayoutData((Object)gd);
        control = this.getChangeControl(this.composite);
        return this.composite;
    }

    protected Control getChangeControl(Composite parent) {
        if (this.bar.getControl() != null && !this.bar.getControl().isDisposed()) {
            return this.bar.getControl();
        }
        return this.bar.createControl(parent);
    }

    @Override
    public void action(String command) {
        if (NEW.equals(command)) {
            String newValue = this.changePressed();
            if (newValue != null) {
                this.resetChoices();
            }
        } else if (SELECT_ALL.equals(command)) {
            MultipleChoiceFieldEditor.Choice[] cs = this.choicesArray.toArray(new MultipleChoiceFieldEditor.Choice[0]);
            int i = 0;
            while (i < cs.length) {
                cs[i].setSelected(true);
                ++i;
            }
            this.fireValueChange();
        } else if (DESELECT_ALL.equals(command)) {
            MultipleChoiceFieldEditor.Choice[] cs = this.choicesArray.toArray(new MultipleChoiceFieldEditor.Choice[0]);
            int i = 0;
            while (i < cs.length) {
                cs[i].setSelected(false);
                ++i;
            }
            this.fireValueChange();
        }
    }

    protected String changePressed() {
        if (this.change == null) {
            return null;
        }
        Properties p = new Properties();
        p.put("shell", this.bar.getControl().getShell());
        this.change.setObject((Object)p);
        int i = this.change.execute();
        if (i != 0) {
            return null;
        }
        return p.getProperty("value");
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getListChangeControl(parent)};
    }
}

