/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.dnd.ControlDragDrop;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;
import org.jboss.tools.common.model.ui.navigator.NavigatorStatusLineProvider;
import org.jboss.tools.common.model.ui.navigator.TreeDragDropProvider;
import org.jboss.tools.common.model.ui.navigator.TreeViewerMenuInvoker;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.common.model.ui.outline.OutlineContentProvider;
import org.jboss.tools.common.model.ui.outline.OutlineMenuInvoker;
import org.jboss.tools.common.model.ui.select.XModelObjectSelectionProvider;
import org.jboss.tools.common.model.util.XModelObjectCache;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;

public class XModelObjectContentOutlineProvider
extends ContentOutlinePage {
    XModel model;
    XModelObjectCache cache;
    List<XFilteredTreeConstraint> filters = new ArrayList<XFilteredTreeConstraint>();
    OutlineContentProvider content = new OutlineContentProvider();
    TreeViewerMenuInvoker menu = new OutlineMenuInvoker();
    TreeViewerModelListenerImpl listener = new TreeViewerModelListenerImpl();
    XModelTreeListenerSWTSync syncListener = new XModelTreeListenerSWTSync(this.listener);
    private TreeDragDropProvider dndProvider = new TreeDragDropProvider();
    private ControlDragDrop dnd = new ControlDragDrop();
    private XModelObjectSelectionProvider selectionProvider = new XModelObjectSelectionProvider();
    private NavigatorStatusLineProvider statusLineProvider = new NavigatorStatusLineProvider();
    private ISelectionListener fSelectionListener = null;

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionListener());
    }

    public void dispose() {
        super.dispose();
        this.model.removeModelTreeListener((XModelTreeListener)this.syncListener);
        if (this.syncListener != null) {
            this.syncListener.dispose();
        }
        this.syncListener = null;
        this.listener = null;
        if (this.content != null) {
            this.content.dispose();
        }
        this.content = null;
        if (this.selectionProvider != null) {
            this.selectionProvider.dispose();
        }
        this.selectionProvider = new XModelObjectSelectionProvider();
        if (this.getSite() == null) {
            return;
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.getSelectionListener());
    }

    public void setCache(XModelObjectCache cache) {
        this.cache = cache;
        this.model = cache.getObject().getModel();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.content = new OutlineContentProvider();
        for (XFilteredTreeConstraint filter : this.filters) {
            this.content.addFilter(filter);
        }
        this.content.setRoot(this.cache);
        this.selectionProvider.addHost("tree", (ISelectionProvider)this.getTreeViewer(), true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.getTreeViewer().setContentProvider((IContentProvider)this.content);
        this.getTreeViewer().setInput((Object)this.cache);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new NavigatorLabelProvider());
        this.menu.setViewer((Viewer)this.getTreeViewer());
        if (!this.content.isProjectEnabled) {
            this.getTreeViewer().getTree().addMouseListener((MouseListener)this.menu);
            this.getTreeViewer().getTree().addKeyListener((KeyListener)this.menu);
        }
        this.listener = new TreeViewerModelListenerImpl();
        this.syncListener = new XModelTreeListenerSWTSync(this.listener);
        this.listener.setViewer(this.getTreeViewer());
        this.model.addModelTreeListener((XModelTreeListener)this.syncListener);
        this.dnd.setProvider(this.dndProvider);
        this.dndProvider.setTree(this.getTreeViewer().getTree());
        if (!this.content.isProjectEnabled) {
            this.dnd.enable();
        } else {
            this.dnd.enableDrag();
        }
        this.initListeners(this.getTreeViewer());
        this.getTreeViewer().setExpandedState((Object)this.cache.getObject(), true);
    }

    public void addFilter(XFilteredTreeConstraint filter) {
        this.filters.add(filter);
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XModelObjectContentOutlineProvider.this.handleSelectionChanged(event);
            }
        });
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateStatusLine(sel);
    }

    protected void updateStatusLine(IStructuredSelection selection) {
        String msg = this.statusLineProvider.getStatusLineMessage(selection);
        this.getSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    public TreeViewerMenuInvoker getOutlineMenuInvoker() {
        return this.menu;
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void disableDnd() {
        this.dnd.setProvider(null);
    }

    private ISelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new PostSelectionServiceListener();
        }
        return this.fSelectionListener;
    }

    private ISelection mapSelection(TreeViewer viewer, ISelection selection) {
        return selection;
    }

    private class PostSelectionServiceListener
    implements ISelectionListener {
        private PostSelectionServiceListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(XModelObjectContentOutlineProvider.this.getControl() == null || XModelObjectContentOutlineProvider.this.getControl().isDisposed() || XModelObjectContentOutlineProvider.this.getControl().isFocusControl() || XModelObjectContentOutlineProvider.this.selectionProvider.isFiringSelection())) {
                if (part instanceof ViewPart) {
                    return;
                }
                ISelection validContentSelection = XModelObjectContentOutlineProvider.this.mapSelection(XModelObjectContentOutlineProvider.this.getTreeViewer(), selection);
                boolean isLinked = true;
                if (isLinked) {
                    XModelObjectContentOutlineProvider.this.getTreeViewer().setSelection(validContentSelection, true);
                }
            }
        }
    }
}

