/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.views.palette.IIgnoreSelection;

public class PaletteInsertHelper {
    public static final String PROPOPERTY_TAG_NAME = "tag name";
    public static final String PROPOPERTY_START_TEXT = "start text";
    public static final String PROPOPERTY_END_TEXT = "end text";
    public static final String PROPOPERTY_NEW_LINE = "new line";
    public static final String PROPOPERTY_REFORMAT_BODY = "automatically reformat tag body";
    public static final String PROPOPERTY_SELECTION_PROVIDER = "selectionProvider";
    static PaletteInsertHelper instance = new PaletteInsertHelper();

    public static PaletteInsertHelper getInstance() {
        return instance;
    }

    public void insertIntoEditor(ITextEditor editor, Properties p) {
        if (editor == null) {
            return;
        }
        if (!PaletteInsertHelper.isEditable(editor)) {
            ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
            String name = editor.getEditorInput().getName();
            String mes = "Source " + name + " is read-only";
            if (editor != null && PaletteInsertHelper.isEditable(editor.getEditorInput())) {
                mes = "Please activate Source tab.";
            }
            d.showDialog("Warning", mes, new String[]{"OK"}, null, 2);
            return;
        }
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ISelectionProvider selProvider = editor.getSelectionProvider();
        p.put(PROPOPERTY_SELECTION_PROVIDER, selProvider);
        this.insertIntoEditorInternal(doc, p);
    }

    static boolean isEditable(ITextEditor editor) {
        if (editor == null) {
            return false;
        }
        return editor.isEditable();
    }

    static boolean isEditable(IEditorInput input) {
        XModelObject o;
        if (input instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)input).getFile();
            return f != null && !f.isReadOnly();
        }
        return !(input instanceof IModelObjectEditorInput) || (o = ((IModelObjectEditorInput)input).getXModelObject()) == null || o.isObjectEditable();
    }

    public void insertIntoEditor(ISourceViewer v, Properties p) {
        String startText = p.getProperty(PROPOPERTY_START_TEXT);
        String endText = p.getProperty(PROPOPERTY_END_TEXT);
        ISelectionProvider selProvider = (ISelectionProvider)p.get(PROPOPERTY_SELECTION_PROVIDER);
        if (selProvider == null) {
            p.put(PROPOPERTY_SELECTION_PROVIDER, v.getSelectionProvider());
        }
        IDocument d = v.getDocument();
        String[] texts = new String[]{startText, endText};
        this.modify(v, p, texts);
        startText = texts[0];
        endText = texts[1];
        if (startText != null) {
            p.setProperty(PROPOPERTY_START_TEXT, startText);
        }
        if (endText != null) {
            p.setProperty(PROPOPERTY_END_TEXT, endText);
        }
        IEditorPart activeEditor = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.insertIntoEditorInternal(d, p);
        if (v instanceof IIgnoreSelection) {
            ((IIgnoreSelection)v).setIgnore(true);
        }
        if (activeEditor != null) {
            activeEditor.getSite().getPage().activate((IWorkbenchPart)activeEditor);
        }
        if (v instanceof IIgnoreSelection) {
            ((IIgnoreSelection)v).setIgnore(false);
        }
    }

    protected void modify(ISourceViewer v, Properties p, String[] texts) {
    }

    protected void insertIntoEditorInternal(IDocument doc, Properties p) {
        int pos;
        String startText = p.getProperty(PROPOPERTY_START_TEXT);
        String endText = p.getProperty(PROPOPERTY_END_TEXT);
        String newline = p.getProperty(PROPOPERTY_NEW_LINE);
        boolean reformat = "yes".equals(p.getProperty(PROPOPERTY_REFORMAT_BODY));
        ISelectionProvider selProvider = (ISelectionProvider)p.get(PROPOPERTY_SELECTION_PROVIDER);
        if (doc == null || selProvider == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)selProvider.getSelection();
        int offset = selection.getOffset();
        int length = selection.getLength();
        String body = null;
        try {
            body = length > 0 ? doc.get(offset, length) : "";
        }
        catch (BadLocationException e1) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e1);
        }
        startText = startText == null ? "" : PaletteInsertHelper.prepare(PaletteInsertHelper.prepare(startText, "\\n", PaletteInsertHelper.getLineDelimiter(doc)), "\\t", "\t");
        endText = endText == null ? "" : PaletteInsertHelper.prepare(PaletteInsertHelper.prepare(endText, "\\n", PaletteInsertHelper.getLineDelimiter(doc)), "\\t", "\t");
        String text = reformat ? PaletteInsertHelper.format(doc, offset, length, body, startText, endText, newline) : String.valueOf(startText) + body + endText;
        String lineDelimiter = PaletteInsertHelper.getLineDelimiter(doc);
        if (reformat && text.startsWith(lineDelimiter)) {
            try {
                int ln = doc.getLineOfOffset(offset);
                int off = doc.getLineOffset(ln);
                if (off == offset) {
                    text = text.substring(1);
                } else {
                    String s = doc.get(off, offset - off).trim();
                    if (s.length() == 0) {
                        text = text.substring(lineDelimiter.length());
                        length += offset - off;
                        offset = off;
                    }
                }
            }
            catch (BadLocationException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        if ((pos = text.indexOf("|")) >= 0) {
            text = String.valueOf(text.substring(0, pos)) + text.substring(pos + 1);
        } else {
            pos = text.length();
        }
        try {
            doc.replace(offset, length, text);
        }
        catch (BadLocationException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
        }
        TextSelection sel = new TextSelection(offset + pos, 0);
        selProvider.setSelection((ISelection)sel);
    }

    private static String prepare(String text, String pattern, String replacer) {
        int index;
        String res = text;
        while ((index = res.indexOf(pattern)) != -1) {
            res = String.valueOf(res.substring(0, index)) + replacer + res.substring(index + pattern.length());
        }
        return res;
    }

    private static String format(IDocument d, int offset, int length, String body, String startText, String endText, String newline) {
        String lineDelimiter = PaletteInsertHelper.getLineDelimiter(d);
        boolean indentBody = startText != null && startText.length() > 0 && endText != null && endText.length() > 0;
        String firstLineIndent = "";
        boolean indentFirstLine = false;
        if (length == 0) {
            firstLineIndent = PaletteInsertHelper.getIndentOfLineOfOffset(d, offset);
        } else {
            firstLineIndent = PaletteInsertHelper.getIndentOfFirstLine(d, offset);
            indentFirstLine = true;
        }
        String lastLineIndent = "";
        boolean appendFirstDelimiter = true;
        try {
            if (d != null && d.getLength() > offset && offset >= 0 && d.getLineOffset(d.getLineOfOffset(offset)) == offset) {
                appendFirstDelimiter = false;
            }
        }
        catch (BadLocationException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
        }
        if (body == null || body.length() == 0) {
            appendFirstDelimiter = false;
        }
        boolean appendLastDelimiter = true;
        try {
            int line = d.getLineOfOffset(offset + length);
            int lineOffset = d.getLineOffset(line);
            int lineLength = d.getLineInformation(line).getLength();
            lastLineIndent = PaletteInsertHelper.getIndentOfLine(d.get(offset + length, lineOffset + lineLength - offset - length), lineDelimiter);
            if (lineOffset + lineLength - offset - length == 0) {
                appendLastDelimiter = false;
            }
        }
        catch (BadLocationException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
        }
        StringBuffer buffer = new StringBuffer();
        if (startText != null && startText.length() > 0) {
            if (appendFirstDelimiter) {
                buffer.append(lineDelimiter);
            }
            if (indentFirstLine) {
                buffer.append(firstLineIndent);
            }
            StringTokenizer st = new StringTokenizer(startText, "\n", true);
            boolean isFirst = true;
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if ("\n".equals(t)) {
                    buffer.append(t);
                    isFirst = false;
                    continue;
                }
                if (!isFirst) {
                    buffer.append(firstLineIndent);
                }
                buffer.append(t);
            }
            if (!"false".equals(newline)) {
                buffer.append(lineDelimiter);
            }
            body = body == null || body.length() == 0 ? "" : String.valueOf(firstLineIndent) + body.substring(PaletteInsertHelper.getIndentOfLine(body, lineDelimiter).length());
        }
        int deltaSize = indentBody ? PaletteInsertHelper.getTabWidth() : 0;
        boolean appendPreEndLineDelimiter = true;
        if (body != null && body.length() > 0) {
            LineIterator iterator = new LineIterator(body);
            while (iterator.hasNext()) {
                Object o = iterator.next();
                String line = o == null ? null : o.toString();
                String lineIndent = PaletteInsertHelper.getIndentOfLine(line, PaletteInsertHelper.getLineDelimiter(d));
                String lineContent = line.substring(lineIndent.length());
                appendPreEndLineDelimiter = true;
                if (lineContent.length() == 0) {
                    buffer.append(line);
                    if (!iterator.hasNext()) {
                        appendPreEndLineDelimiter = false;
                    }
                } else {
                    int indentSize = PaletteInsertHelper.calculateDisplayedWidth(lineIndent, PaletteInsertHelper.getTabWidth());
                    lineIndent = PaletteInsertHelper.changePrefix(lineIndent.trim(), indentSize + deltaSize, PaletteInsertHelper.useSpaces(), PaletteInsertHelper.getTabWidth());
                    buffer.append(lineIndent);
                    buffer.append(lineContent);
                }
                if (!iterator.hasNext()) continue;
                buffer.append(lineDelimiter);
            }
        } else {
            String lineIndent = PaletteInsertHelper.changePrefix(firstLineIndent, PaletteInsertHelper.calculateDisplayedWidth(firstLineIndent, PaletteInsertHelper.getTabWidth()) + deltaSize, PaletteInsertHelper.useSpaces(), PaletteInsertHelper.getTabWidth());
            buffer.append(lineIndent);
            if (startText.indexOf(124) == -1 && endText.indexOf(124) == -1) {
                buffer.append('|');
            }
        }
        if (endText != null && endText.length() > 0) {
            if (appendPreEndLineDelimiter) {
                buffer.append(lineDelimiter);
            }
            buffer.append(firstLineIndent);
            buffer.append(endText);
            if (appendLastDelimiter) {
                buffer.append(lineDelimiter);
                int indentLength = PaletteInsertHelper.calculateDisplayedWidth(firstLineIndent, PaletteInsertHelper.getTabWidth()) - PaletteInsertHelper.calculateDisplayedWidth(lastLineIndent, PaletteInsertHelper.getTabWidth());
                if (indentLength > 0) {
                    buffer.append(PaletteInsertHelper.changePrefix(lastLineIndent.trim(), indentLength, PaletteInsertHelper.useSpaces(), PaletteInsertHelper.getTabWidth()));
                }
            }
        }
        return buffer.toString();
    }

    private static int getTabWidth() {
        return Platform.getPreferencesService().getInt("org.eclipse.ui.editors", "tabWidth", 4, new IScopeContext[]{new InstanceScope()});
    }

    private static boolean useSpaces() {
        return false;
    }

    private static int calculateDisplayedWidth(String string, int tabWidth) {
        int column = 0;
        int i = 0;
        while (i < string.length()) {
            column = '\t' == string.charAt(i) ? (column += tabWidth - column % tabWidth) : ++column;
            ++i;
        }
        return column;
    }

    /*
     * Unable to fully structure code
     */
    private static String changePrefix(String string, int displayedWidth, boolean useSpaces, int tabWidth) {
        block4: {
            buffer = new StringBuffer(string);
            column = PaletteInsertHelper.calculateDisplayedWidth(buffer.toString(), tabWidth);
            if (column > displayedWidth) {
                return string;
            }
            if (!useSpaces) ** GOTO lbl20
            while (column != displayedWidth) {
                buffer.append(' ');
                ++column;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (column + tabWidth - column % tabWidth <= displayedWidth) {
                    buffer.append('\t');
                    column += tabWidth - column % tabWidth;
                    continue;
                }
                buffer.append(' ');
                ++column;
lbl20:
                // 3 sources

                ** while (column != displayedWidth)
            }
        }
        return buffer.toString();
    }

    public static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return System.getProperty("line.separator");
    }

    private static String getIndentOfFirstLine(IDocument d, int offset) {
        String indent = "";
        if (d == null) {
            return indent;
        }
        try {
            int line = d.getLineOfOffset(offset);
            while (line >= 0) {
                String lineText = d.get(d.getLineOffset(line), d.getLineLength(line));
                if (lineText.trim().length() > 0) {
                    return PaletteInsertHelper.getIndentOfLine(lineText, PaletteInsertHelper.getLineDelimiter(d));
                }
                --line;
            }
        }
        catch (BadLocationException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
        }
        return indent;
    }

    private static String getIndentOfLineOfOffset(IDocument d, int offset) {
        String indent = "";
        if (d == null) {
            return indent;
        }
        try {
            int line = d.getLineOfOffset(offset);
            String lineText = d.get(d.getLineOffset(line), d.getLineLength(line));
            return PaletteInsertHelper.getIndentOfLine(lineText, PaletteInsertHelper.getLineDelimiter(d));
        }
        catch (BadLocationException ex) {
            ModelUIPlugin.getPluginLog().logError((Throwable)ex);
            return indent;
        }
    }

    private static String getIndentOfLine(String line, String lineDelimiter) {
        int i = 0;
        while (i < line.length()) {
            if (!Character.isWhitespace(line.charAt(i)) || lineDelimiter != null && lineDelimiter.indexOf(line.charAt(i)) != -1) break;
            ++i;
        }
        return line.substring(0, i);
    }

    private static final class LineIterator
    implements Iterator {
        private final IDocument fDocument;
        private int fLineIndex;

        public LineIterator(String string) {
            this.fDocument = new Document(string);
        }

        @Override
        public boolean hasNext() {
            return this.fLineIndex != this.fDocument.getNumberOfLines();
        }

        public Object next() {
            try {
                IRegion region = this.fDocument.getLineInformation(this.fLineIndex++);
                return this.fDocument.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

