/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

public class SetupModuleHandler
implements StrutsConstants {
    public static void setupModule(XModelObject object, String module, String fsname) throws XModelException {
        Properties info;
        XModel model = object.getModel();
        if (module.length() > 0 && module.charAt(0) != '/') {
            throw new RuntimeException(StrutsUIMessages.MODULE_NAME);
        }
        String prevMod = StrutsProcessStructureHelper.instance.getProcessModule(object);
        XModelObject fsOld = prevMod == null ? null : SetupModuleHandler.getFileSystem(model, prevMod);
        XModelObject fsNew = null;
        if (fsname != null && fsname.length() > 0) {
            fsNew = model.getByPath("FileSystems/" + fsname);
        }
        if (fsNew != null) {
            XModelObject fsPrev;
            info = SetupModuleHandler.getProperties(fsNew.getAttributeValue("info"));
            if ("Web".equals(info.getProperty("Content-Type")) && !module.equals(info.getProperty("Struts-Module")) && !SetupModuleHandler.unmarkModule(model, "Setup Module", info.getProperty("Struts-Module"))) {
                return;
            }
            if (fsNew == fsOld) {
                fsOld = null;
            }
            if (fsNew != (fsPrev = SetupModuleHandler.getFileSystem(model, module)) && fsPrev != null) {
                Properties info2 = SetupModuleHandler.getProperties(fsPrev.getAttributeValue("info"));
                info2.remove("Content-Type");
                info2.remove("Struts-Module");
                model.changeObjectAttribute(fsPrev, "info", SetupModuleHandler.getString(info2));
            }
            info.setProperty("Content-Type", "Web");
            if (module.length() > 0) {
                info.setProperty("Struts-Module", module);
            } else {
                info.remove("Struts-Module");
            }
            model.changeObjectAttribute(fsNew, "info", SetupModuleHandler.getString(info));
        } else {
            XModelObject webRoot = SetupModuleHandler.getWebRoot(object.getModel());
            if (webRoot != null && module.length() > 0) {
                XModelObject w = object.getModel().getByPath("Web/" + module.replace('/', '#'));
                if (w != null) {
                    XModelObject fs;
                    String s = w.getAttributeValue("root file system");
                    XModelObject xModelObject = fs = s.length() == 0 ? null : object.getModel().getByPath("FileSystems/" + s);
                    if (fs != null) {
                        return;
                    }
                }
                XModelObject fs = SetupModuleHandler.createFileSystem(webRoot, module);
                fsname = fs.getAttributeValue("name");
            } else if (webRoot != null) {
                fsname = webRoot.getAttributeValue("name");
            }
        }
        if (fsOld != null && module.equals(prevMod)) {
            info = SetupModuleHandler.getProperties(fsOld.getAttributeValue("info"));
            info.remove("Content-Type");
            info.remove("Struts-Module");
            model.changeObjectAttribute(fsOld, "info", SetupModuleHandler.getString(info));
        }
        if (object.getPath() != null && fsname != null) {
            WebModulesHelper.getInstance(model).setModule(model, prevMod, module, XModelObjectLoaderUtil.getResourcePath((XModelObject)object.getParent()), fsname);
        }
    }

    static XModelObject getFileSystem(XModel model, String module) {
        return WebModulesHelper.getInstance(model).getFileSystem(module);
    }

    static XModelObject getWebRoot(XModel model) {
        return WebModulesHelper.getInstance(model).getWebRoot();
    }

    public static Properties getProperties(XModelObject fs) {
        return SetupModuleHandler.getProperties(fs.getAttributeValue("info"));
    }

    public static Properties getProperties(String s) {
        Properties props = new Properties();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreElements()) {
            String t = st.nextToken();
            int i = t.indexOf(61);
            if (i < 0) {
                props.setProperty(t, "");
                continue;
            }
            String n = t.substring(0, i).trim();
            String v = t.substring(i + 1).trim();
            props.setProperty(n, v);
        }
        return props;
    }

    public static String getString(Properties props) {
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        String s = "";
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            s = String.valueOf(s) + (s.length() > 0 ? "," : "") + entry.getKey() + "=" + entry.getValue();
        }
        return s;
    }

    private static XModelObject createFileSystem(XModelObject webroot, String module) throws XModelException {
        XModel model = webroot.getModel();
        String mn = module;
        if (mn.startsWith("/")) {
            mn = mn.substring(1);
        }
        String subpath = mn;
        SetupModuleHandler.createFolder(webroot, subpath);
        XModelObject fs = model.createModelObject("FileSystemFolder", null);
        String location = String.valueOf(webroot.getAttributeValue("location")) + "/" + subpath;
        fs.setAttributeValue("location", location);
        XModelObject fsp = webroot.getParent();
        mn = mn.replace('/', '#');
        String fsname = XModelObjectUtil.createNewChildName((String)mn, (XModelObject)fsp);
        fs.setAttributeValue("name", fsname);
        Properties p = SetupModuleHandler.getProperties(fs);
        p.setProperty("Content-Type", "Web");
        p.setProperty("Struts-Module", module);
        fs.setAttributeValue("info", SetupModuleHandler.getString(p));
        DefaultCreateHandler.addCreatedObject((XModelObject)fsp, (XModelObject)fs, (int)-1);
        return fs;
    }

    private static XModelObject createFolder(XModelObject parent, String path) throws XModelException {
        int i = path.indexOf(47);
        String part = i < 0 ? path : path.substring(0, i);
        XModelObject folder = parent.getChildByPath(part);
        if (folder == null) {
            folder = parent.getModel().createModelObject("FileFolder", null);
            folder.setAttributeValue("name", part);
            DefaultCreateHandler.addCreatedObject((XModelObject)parent, (XModelObject)folder, (int)-1);
        }
        if (i < 0) {
            return folder;
        }
        path = path.substring(i + 1);
        return SetupModuleHandler.createFolder(folder, path);
    }

    public static boolean unmarkModule(XModel model, String title, String module) {
        ServiceDialog d = model.getService();
        String msg = null;
        msg = module != null && module.length() > 0 ? NLS.bind((String)StrutsUIMessages.FILE_SYSTEM_IS_USED_AS_ROOT_FOR_STRUTS_MODULE, (Object)module) : StrutsUIMessages.FILE_SYSTEM_IS_USED_AS_ROOT_FOR_WEB_APPLICATION;
        int i = d.showDialog(title, msg, new String[]{StrutsUIMessages.YES, StrutsUIMessages.NO}, null, 2);
        return i == 0;
    }
}

