/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.devstudio.core.splash;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SplashHandler
extends BasicSplashHandler {
    private static final String STARTUP_VERSION_FONT_DATA = "startupVersionFont";
    private static final String STARTUP_VERSION_LOCATION = "startupVersionLocation";

    public void init(Shell splash) {
        int foregroundColorInteger;
        super.init(splash);
        String progressRectString = null;
        String messageRectString = null;
        String foregroundColorString = null;
        String versionLocation = null;
        String versionFont = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
            versionLocation = product.getProperty(STARTUP_VERSION_LOCATION);
            versionFont = product.getProperty(STARTUP_VERSION_FONT_DATA);
        }
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(10, 10, 300, 15));
        this.setProgressRect(progressRect);
        Rectangle messageRect = StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(10, 35, 300, 15));
        this.setMessageRect(messageRect);
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
        }
        catch (Exception exception) {
            foregroundColorInteger = 13817855;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        final String versionString = this.getVersionString();
        final Point versionLocationPoint = StringConverter.asPoint((String)versionLocation, (Point)new Point(228, 209));
        final FontData fd = StringConverter.asFontData((String)versionFont, (FontData)new FontData("Arial", 9, 1));
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setTextAntialias(1);
                Font newF = new Font(e.gc.getDevice(), fd);
                e.gc.setFont(newF);
                Point point = e.gc.textExtent(versionString);
                e.gc.setForeground(SplashHandler.this.getForeground());
                if (point.x > 199) {
                    e.gc.drawText(versionString, 29, versionLocationPoint.y, true);
                } else {
                    e.gc.drawText(versionString, versionLocationPoint.x - point.x, versionLocationPoint.y, true);
                }
            }
        });
    }

    private String getVersionString() {
        Bundle bundle = Platform.getBundle((String)"com.jboss.devstudio.core");
        String versionString = (String)bundle.getHeaders().get("Bundle-Version");
        if (versionString != null) {
            Version version = new Version(versionString);
            String qualifier = null;
            if (Boolean.getBoolean("SHOW_BUILDID_ON_STARTUP") || PrefUtil.getInternalPreferenceStore().getBoolean("SHOW_BUILDID_ON_STARTUP")) {
                qualifier = version.getQualifier();
            } else {
                qualifier = version.getQualifier();
                int ix = qualifier.indexOf(45);
                if (ix > 0) {
                    qualifier = qualifier.substring(0, ix);
                }
            }
            if ("qualifier".equals(qualifier)) {
                return String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro();
            }
            return String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro() + "." + qualifier;
        }
        return "";
    }
}

