/*
 * JBoss, the OpenSource WebOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi.work;

import java.util.EventObject;

/**
 * Events that occur on work
 * @version $Revision: 1.4 $
 */
public class WorkEvent extends EventObject
{
   /** The WORK_ACCEPTED value */
   public static final int WORK_ACCEPTED = 1;
   /** The WORK_REJECTED value */
   public static final int WORK_REJECTED = 2;
   /** The WORK_STARTED  value */
   public static final int WORK_STARTED = 3;
   /** The WORK_COMPLETED value */
   public static final int WORK_COMPLETED = 4;
   
   /** The event type */
   private int type;
   /** The work */
   private Work work;
   /** The exception */
   private WorkException e;
   /** The start delay in millis */
   private long startDuration;
   
   /**
    * Create a new WorkEvent
    *
    * @param source the source of the event
    * @param type the type
    * @param work the work
    * @param e the exception
    */
   public WorkEvent(Object source, int type, Work work, WorkException e)
   {
      this(source, type, work, e, 0l);
   }
   
   /**
    * Create a new WorkEvent
    *
    * @param source the source of the event
    * @param type the type
    * @param work the work
    * @param e the exception
    * @param startDuration the delay in the start in milliseconds
    */
   public WorkEvent(Object source, int type, Work work, WorkException e, long startDuration)
   {
      super(source);
      this.type = type;
      this.work = work;
      this.e = e;
      this.startDuration = startDuration;
   }
   
   /**
    * Get the type
    *
    * @return the type
    */
   public int getType()
   {
      return type;
   }
   
   /**
    * Get the work
    *
    * @return the work
    */
   public Work getWork()
   {
      return work;
   }
   
   /**
    * Get the exception
    *
    * @return the work exception
    */
   public WorkException getException()
   {
      return e;
   }
   
   /**
    * Get the start duration
    *
    * @return the start duration
    */
   public long getStartDuration()
   {
      return startDuration;
   }
}