/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.effect;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.effect.Effect;
import org.primefaces.component.effect.EffectBuilder;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class EffectRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Effect effect = (Effect)component;
        String parentClientId = effect.getParent().getClientId(facesContext);
        String effectedComponentClientId = null;
        if (effect.getFor() != null) {
            UIComponent target = ComponentUtils.findComponentById(facesContext, (UIComponent)facesContext.getViewRoot(), effect.getFor());
            effectedComponentClientId = target.getClientId(facesContext);
        } else {
            effectedComponentClientId = parentClientId;
        }
        String animation = this.getEffectBuilder(effect, effectedComponentClientId).build();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady(\"" + parentClientId + "\", function() {\n");
        writer.write("YAHOO.util.Event.addListener(\"" + parentClientId + "\", \"" + effect.getEvent() + "\", " + "function(e) {" + animation + "});\n");
        writer.write("});\n");
        writer.endElement("script");
    }

    private EffectBuilder getEffectBuilder(Effect effect, String effectedComponentClientId) {
        EffectBuilder effectBuilder = new EffectBuilder(effect.getType(), effectedComponentClientId);
        for (UIComponent child : effect.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            effectBuilder.withOption(param.getName(), (String)param.getValue());
        }
        effectBuilder.atSpeed(effect.getSpeed());
        return effectBuilder;
    }
}

