/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import javax.el.MethodExpression;
import javax.faces.component.UICommand;
import javax.faces.context.FacesContext;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpSession;
import org.richfaces.component.PushEventTracker;
import org.richfaces.component.PushListenersManager;

public class UIPush
extends UICommand {
    public static final String COMPONENT_TYPE = "org.richfaces.Push";
    public static final String COMPONENT_FAMILY = "org.richfaces.Push";
    private transient boolean hasActiveBehavior = false;

    public void encodeBegin(FacesContext context) throws IOException {
        MethodExpression producer = this.getEventProducer();
        if (null != producer) {
            producer.invoke(context.getELContext(), new Object[]{this.getListener(context)});
        }
        super.encodeBegin(context);
    }

    private PushEventTracker getListener(FacesContext context) {
        PushListenersManager pushListenersManager = PushListenersManager.getInstance(context);
        return pushListenersManager.getListener(this.getListenerId(context));
    }

    public String getListenerId(FacesContext context) {
        Object session = context.getExternalContext().getSession(false);
        StringBuffer id = new StringBuffer();
        if (null != session && session instanceof HttpSession) {
            HttpSession httpSession = (HttpSession)session;
            id.append(httpSession.getId());
        }
        id.append(context.getViewRoot().getViewId());
        id.append(':');
        id.append(this.getClientId(context));
        return id.toString();
    }

    public MethodExpression getEventProducer() {
        return (MethodExpression)this.getStateHelper().get((Serializable)((Object)PropertyKeys.eventProducer));
    }

    public void setEventProducer(MethodExpression producer) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.eventProducer), (Object)producer);
    }

    public int getInterval() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.interval), (Object)1000);
    }

    public void setInterval(int interval) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.interval), (Object)interval);
    }

    public boolean isEnabled() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.enabled), (Object)Boolean.TRUE).toString());
    }

    public void setEnabled(boolean enable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.enabled), (Object)enable);
    }

    public String getFamily() {
        return "org.richfaces.Push";
    }

    public void queueEvent(FacesEvent e) {
        if (e instanceof BehaviorEvent) {
            this.hasActiveBehavior = true;
        }
        super.queueEvent(e);
    }

    public boolean isHasActiveBehavior() {
        return this.hasActiveBehavior;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyKeys {
        eventProducer,
        enabled,
        interval;

    }
}

