/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.ApplicationException;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.JSF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Interceptor(stateless=true)
public class RollbackInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 5551801508325093417L;

    @Override
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Exception e) {
            if (this.isRollbackRequired(e)) {
                try {
                    Transaction.instance().setRollbackOnly();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private boolean isRollbackRequired(Exception e) {
        boolean isJavaBean = this.getComponent().getType() == ComponentType.JAVA_BEAN;
        Class<?> clazz = e.getClass();
        return this.isSystemException(e, isJavaBean, clazz) || isJavaBean && clazz.isAnnotationPresent(EJB.APPLICATION_EXCEPTION) && EJB.rollback(clazz.getAnnotation(EJB.APPLICATION_EXCEPTION)) || clazz.isAnnotationPresent(ApplicationException.class) && clazz.getAnnotation(ApplicationException.class).rollback();
    }

    private boolean isSystemException(Exception e, boolean isJavaBean, Class<? extends Exception> clazz) {
        return isJavaBean && e instanceof RuntimeException && !clazz.isAnnotationPresent(EJB.APPLICATION_EXCEPTION) && !clazz.isAnnotationPresent(ApplicationException.class) && !JSF.VALIDATOR_EXCEPTION.isInstance(e) && !JSF.CONVERTER_EXCEPTION.isInstance(e);
    }
}

