/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.microcontainer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;

public class SeamComponentRegistryPlugin
implements KernelRegistryPlugin {
    private static Pattern SCOPE = Pattern.compile(";scope=([a-zA-Z]+)");
    private static Pattern CREATE = Pattern.compile(";create=(true|false)");

    public KernelRegistryEntry getEntry(Object object) {
        Object component;
        String componentName = object.toString();
        if (object instanceof Class) {
            component = Component.getInstance((Class)((Class)object));
        } else {
            Boolean create = SeamComponentRegistryPlugin.parseCreate(componentName);
            ScopeType scopeType = SeamComponentRegistryPlugin.parseScopeType(componentName);
            int p = componentName.indexOf(";");
            if (p > 0) {
                componentName = componentName.substring(p);
            }
            component = scopeType != null ? Component.getInstance((String)componentName, (ScopeType)scopeType, (boolean)create) : Component.getInstance((String)componentName, (boolean)create);
        }
        return new AbstractKernelRegistryEntry((Object)componentName, component);
    }

    protected static Boolean parseCreate(String name) {
        Boolean create = Boolean.TRUE;
        Matcher createMatcher = CREATE.matcher(name);
        if (createMatcher.find()) {
            create = Boolean.parseBoolean(createMatcher.group(1));
        }
        return create;
    }

    protected static ScopeType parseScopeType(String name) {
        ScopeType scopeType = null;
        Matcher scopeMatcher = SCOPE.matcher(name);
        if (scopeMatcher.find()) {
            scopeType = ScopeType.valueOf((String)scopeMatcher.group(1));
        }
        return scopeType;
    }
}

