/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.ioc.spring.SeamTargetSource;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.DefaultAopProxyFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class SeamFactoryBean
extends AbstractFactoryBean
implements InitializingBean {
    private ScopeType scope;
    private String name;
    private Boolean create;
    private SeamTargetSource targetSource;
    private Object proxyInstance;
    private Class type;
    private boolean proxy = false;

    public void afterPropertiesSet() throws Exception {
        if (this.name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.setSingleton(this.proxy);
        this.targetSource = new SeamTargetSource(this.name, this.scope, this.create, this.type);
        if (this.proxy) {
            Class targetClass = this.targetSource.getTargetClass();
            if (targetClass == null) {
                throw new IllegalStateException("Cannot use 'proxy' for an expression without specifying a type.");
            }
            ProxyFactory pf = new ProxyFactory();
            pf.setProxyTargetClass(true);
            pf.setOptimize(true);
            pf.setExposeProxy(false);
            pf.setFrozen(true);
            pf.setAopProxyFactory((AopProxyFactory)new DefaultAopProxyFactory());
            pf.setTargetSource((TargetSource)this.targetSource);
            List<Class> interfaces = this.targetSource.getSeamInterfaces();
            if (targetClass.isInterface()) {
                interfaces.add(targetClass);
            }
            pf.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            this.proxyInstance = pf.getProxy(Thread.currentThread().getContextClassLoader());
        }
        super.afterPropertiesSet();
    }

    protected Object createInstance() throws Exception {
        if (this.proxy) {
            return this.proxyInstance;
        }
        return this.targetSource.getTarget();
    }

    public Class getObjectType() {
        return this.targetSource.getTargetClass();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(ScopeType scope) {
        this.scope = scope;
    }

    public void setCreate(Boolean create) {
        this.create = create;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public void setType(Class type) {
        this.type = type;
    }
}

