/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.remote;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;

public class DataGravitationCleanupCommand
implements ReplicableCommand {
    public static final int METHOD_ID = 34;
    private static final Log log = LogFactory.getLog(DataGravitationCleanupCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private BuddyManager buddyManager;
    private TransactionTable transactionTable;
    private InterceptorChain invoker;
    private CommandsFactory commandsFactory;
    private DataContainer dataContainer;
    private GlobalTransaction globalTransaction;
    private Fqn fqn;
    private Fqn backup;
    private BuddyFqnTransformer buddyFqnTransformer;

    public DataGravitationCleanupCommand(Fqn primary, Fqn backup) {
        this.fqn = primary;
        this.backup = backup;
    }

    public DataGravitationCleanupCommand() {
    }

    public void initialize(BuddyManager buddyManager, InterceptorChain invoker, TransactionTable transactionTable, CommandsFactory commandsFactory, DataContainer dataContainer, BuddyFqnTransformer buddyFqnTransformer) {
        this.buddyManager = buddyManager;
        this.invoker = invoker;
        this.transactionTable = transactionTable;
        this.commandsFactory = commandsFactory;
        this.dataContainer = dataContainer;
        this.buddyFqnTransformer = buddyFqnTransformer;
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.buddyManager.isDataGravitationRemoveOnFind()) {
            GlobalTransaction gtx;
            if (trace) {
                log.trace((Object)("DataGravitationCleanup: Removing primary (" + this.fqn + ") and backup (" + this.backup + ")"));
            }
            if (!this.executeRemove(gtx = this.transactionTable.getCurrentTransaction(), this.fqn)) {
                Boolean result = this.executeRemove(gtx, this.backup);
                if (this.wasNodeRemoved(result)) {
                    Fqn deadBackupRootFqn = null;
                    if (this.buddyFqnTransformer.isDeadBackupFqn(this.backup) && this.buddyFqnTransformer.isDeadBackupRoot(this.backup.getAncestor(this.backup.size() - 2)) && !this.dataContainer.hasChildren(deadBackupRootFqn = this.backup.getParent())) {
                        if (trace) {
                            log.trace((Object)("Removing dead backup region " + deadBackupRootFqn));
                        }
                        this.executeRemove(gtx, deadBackupRootFqn);
                        deadBackupRootFqn = deadBackupRootFqn.getParent();
                        if (!this.dataContainer.hasChildren(deadBackupRootFqn)) {
                            if (trace) {
                                log.trace((Object)("Removing dead backup region " + deadBackupRootFqn));
                            }
                            this.executeRemove(gtx, deadBackupRootFqn);
                        }
                    }
                }
            } else if (trace) {
                log.trace((Object)("Managed to remove primary (" + this.fqn + ").  Not bothering with backups."));
            }
        } else {
            if (trace) {
                log.trace((Object)("DataGravitationCleanup: Evicting primary (" + this.fqn + ") and backup (" + this.backup + ")"));
            }
            this.evictNode(this.fqn);
            this.evictNode(this.backup);
        }
        return null;
    }

    private boolean executeRemove(GlobalTransaction gtx, Fqn toRemove) throws Throwable {
        RemoveNodeCommand removeBackupCommand = this.commandsFactory.buildRemoveNodeCommand(gtx, toRemove);
        InvocationContext ctx = this.invoker.getInvocationContext();
        ctx.getOptionOverrides().setCacheModeLocal(true);
        Object result = this.invoker.invoke(ctx, removeBackupCommand);
        return result != null && (Boolean)result != false;
    }

    private boolean wasNodeRemoved(Object result) {
        return result != null && (Boolean)result != false;
    }

    private void evictNode(Fqn fqn) throws Throwable {
        if (this.dataContainer.exists(fqn)) {
            List<Fqn> toEvict = this.dataContainer.getNodesForEviction(fqn, true);
            for (Fqn aFqn : toEvict) {
                EvictCommand evictFqnCommand = this.commandsFactory.buildEvictFqnCommand(aFqn);
                this.invoker.invoke(evictFqnCommand);
            }
        } else if (trace) {
            log.trace((Object)("Not evicting " + fqn + " as it doesn't exist"));
        }
    }

    public int getCommandId() {
        return 34;
    }

    public Fqn getBackup() {
        return this.backup;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction gtx) {
        this.globalTransaction = gtx;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public Object[] getParameters() {
        return new Object[]{this.fqn, this.backup};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.backup = (Fqn)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataGravitationCleanupCommand that = (DataGravitationCleanupCommand)o;
        if (this.backup != null ? !this.backup.equals(that.backup) : that.backup != null) {
            return false;
        }
        return !(this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.backup != null ? this.backup.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DataGravitationCleanupCommand{fqn=" + this.fqn + ", backup=" + this.backup + '}';
    }
}

